/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.monitorrepository.statisticalcharacterization;

import java.util.Iterator;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.measure.Measure;
import javax.measure.quantity.Quantity;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.metricspec.NumericalBaseMetricDescription;
import org.palladiosimulator.monitorrepository.statisticalcharacterization.StatisticalCharacterizationAggregator;

public class GeometricMeanAggregator
extends StatisticalCharacterizationAggregator {
    public GeometricMeanAggregator(NumericalBaseMetricDescription expectedWindowMetric) {
        super(expectedWindowMetric);
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharaterizationDiscrete(Iterable<MeasuringValue> windowData) {
        double meanOfLogs = StreamSupport.stream(windowData.spliterator(), false).collect(Collectors.averagingDouble(m -> Math.log(this.obtainDataValueFromMeasurement((MeasuringValue)m))));
        double geometricMean = Double.compare(meanOfLogs, 0.0) == 0 || !Double.isFinite(meanOfLogs) ? 0.0 : Math.exp(meanOfLogs);
        return Measure.valueOf((double)geometricMean, super.getDataDefaultUnit());
    }

    @Override
    protected Measure<Double, Quantity> calculateStatisticalCharacterizationContinuous(Iterable<MeasuringValue> windowData) {
        Measure geometricMean = Measure.valueOf((double)0.0, super.getDataDefaultUnit());
        Iterator<MeasuringValue> iterator = windowData.iterator();
        if (iterator.hasNext()) {
            double sumOfLogs = 0.0;
            MeasuringValue currentMeasurement = iterator.next();
            Optional<Object> nextMeasurement = null;
            do {
                nextMeasurement = iterator.hasNext() ? Optional.of(iterator.next()) : Optional.empty();
                sumOfLogs += Math.log(this.obtainDataValueFromMeasurement(currentMeasurement)) * this.obtainCurrentMeasurementValidityLength(currentMeasurement, nextMeasurement).doubleValue((Unit)SI.SECOND);
                if (!nextMeasurement.isPresent()) continue;
                currentMeasurement = nextMeasurement.get();
            } while (nextMeasurement.isPresent());
            double geometricMeanValue = Double.compare(sumOfLogs, 0.0) == 0 || !Double.isFinite(sumOfLogs) ? 0.0 : Math.exp(sumOfLogs / super.getIntervalLength().doubleValue((Unit)SI.SECOND));
            geometricMean = Measure.valueOf((double)geometricMeanValue, super.getDataDefaultUnit());
        }
        return geometricMean;
    }
}

