/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.confidentiality.attackerSpecification.attackSpecification;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum AttackVector implements Enumerator
{
    NETWORK(0, "Network", "Network"),
    ADJACENT_NETWORK(1, "AdjacentNetwork", "AdjacentNetwork"),
    LOCAL(2, "Local", "Local");

    public static final int NETWORK_VALUE = 0;
    public static final int ADJACENT_NETWORK_VALUE = 1;
    public static final int LOCAL_VALUE = 2;
    private static final AttackVector[] VALUES_ARRAY;
    public static final List<AttackVector> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new AttackVector[]{NETWORK, ADJACENT_NETWORK, LOCAL};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static AttackVector get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttackVector result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttackVector getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            AttackVector result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static AttackVector get(int value) {
        switch (value) {
            case 0: {
                return NETWORK;
            }
            case 1: {
                return ADJACENT_NETWORK;
            }
            case 2: {
                return LOCAL;
            }
        }
        return null;
    }

    private AttackVector(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

