/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.confidentiality.context.policy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum PolicyCombiningAlgorithm implements Enumerator
{
    DENY_OVERRIDES(0, "DENY_OVERRIDES", "DENY_OVERRIDES"),
    PERMIT_OVERRIDES(1, "PERMIT_OVERRIDES", "PERMIT_OVERRIDES"),
    FIRST_APPLICABLE(2, "FIRST_APPLICABLE", "FIRST_APPLICABLE"),
    ONLY_ONE_APPLICABLE(3, "ONLY_ONE_APPLICABLE", "ONLY_ONE_APPLICABLE"),
    ORDERED_DENY_OVERRIDES(4, "ORDERED_DENY_OVERRIDES", "ORDERED_DENY_OVERRIDES"),
    ORDERED_PERMIT_OVERRIDES(5, "ORDERED_PERMIT_OVERRIDES", "ORDERED_PERMIT_OVERRIDES"),
    DENY_UNLESS_PERMIT(6, "DENY_UNLESS_PERMIT", "DENY_UNLESS_PERMIT"),
    PERMIT_UNLESS_DENY(7, "PERMIT_UNLESS_DENY", "PERMIT_UNLESS_DENY");

    public static final int DENY_OVERRIDES_VALUE = 0;
    public static final int PERMIT_OVERRIDES_VALUE = 1;
    public static final int FIRST_APPLICABLE_VALUE = 2;
    public static final int ONLY_ONE_APPLICABLE_VALUE = 3;
    public static final int ORDERED_DENY_OVERRIDES_VALUE = 4;
    public static final int ORDERED_PERMIT_OVERRIDES_VALUE = 5;
    public static final int DENY_UNLESS_PERMIT_VALUE = 6;
    public static final int PERMIT_UNLESS_DENY_VALUE = 7;
    private static final PolicyCombiningAlgorithm[] VALUES_ARRAY;
    public static final List<PolicyCombiningAlgorithm> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new PolicyCombiningAlgorithm[]{DENY_OVERRIDES, PERMIT_OVERRIDES, FIRST_APPLICABLE, ONLY_ONE_APPLICABLE, ORDERED_DENY_OVERRIDES, ORDERED_PERMIT_OVERRIDES, DENY_UNLESS_PERMIT, PERMIT_UNLESS_DENY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static PolicyCombiningAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PolicyCombiningAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PolicyCombiningAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            PolicyCombiningAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static PolicyCombiningAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return DENY_OVERRIDES;
            }
            case 1: {
                return PERMIT_OVERRIDES;
            }
            case 2: {
                return FIRST_APPLICABLE;
            }
            case 3: {
                return ONLY_ONE_APPLICABLE;
            }
            case 4: {
                return ORDERED_DENY_OVERRIDES;
            }
            case 5: {
                return ORDERED_PERMIT_OVERRIDES;
            }
            case 6: {
                return DENY_UNLESS_PERMIT;
            }
            case 7: {
                return PERMIT_UNLESS_DENY;
            }
        }
        return null;
    }

    private PolicyCombiningAlgorithm(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

