/**
 * Copyright 2005-2017 by palladiosimulator.org
 */
package org.palladiosimulator.pcm.repository.impl;

import java.lang.reflect.InvocationTargetException;

import java.util.Collection;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.WrappedException;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.InternalEList;

import org.palladiosimulator.pcm.core.entity.impl.EntityImpl;

import org.palladiosimulator.pcm.protocol.Protocol;

import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.repository.RepositoryPackage;
import org.palladiosimulator.pcm.repository.RequiredCharacterisation;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Interface</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * </p>
 * <ul>
 *   <li>{@link org.palladiosimulator.pcm.repository.impl.InterfaceImpl#getParentInterfaces__Interface <em>Parent Interfaces Interface</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.repository.impl.InterfaceImpl#getProtocols__Interface <em>Protocols Interface</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.repository.impl.InterfaceImpl#getRequiredCharacterisations <em>Required Characterisations</em>}</li>
 *   <li>{@link org.palladiosimulator.pcm.repository.impl.InterfaceImpl#getRepository__Interface <em>Repository Interface</em>}</li>
 * </ul>
 *
 * @generated
 */
public abstract class InterfaceImpl extends EntityImpl implements Interface
{
	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public static final String copyright = "Copyright 2005-2017 by palladiosimulator.org";

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected InterfaceImpl()
	{
		super();
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	protected EClass eStaticClass()
	{
		return RepositoryPackage.Literals.INTERFACE;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Interface> getParentInterfaces__Interface()
	{
		return (EList<Interface>)eDynamicGet(RepositoryPackage.INTERFACE__PARENT_INTERFACES_INTERFACE, RepositoryPackage.Literals.INTERFACE__PARENT_INTERFACES_INTERFACE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<Protocol> getProtocols__Interface()
	{
		return (EList<Protocol>)eDynamicGet(RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE, RepositoryPackage.Literals.INTERFACE__PROTOCOLS_INTERFACE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public EList<RequiredCharacterisation> getRequiredCharacterisations()
	{
		return (EList<RequiredCharacterisation>)eDynamicGet(RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS, RepositoryPackage.Literals.INTERFACE__REQUIRED_CHARACTERISATIONS, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Repository getRepository__Interface()
	{
		return (Repository)eDynamicGet(RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE, RepositoryPackage.Literals.INTERFACE__REPOSITORY_INTERFACE, true, true);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public NotificationChain basicSetRepository__Interface(Repository newRepository__Interface, NotificationChain msgs)
	{
		msgs = eBasicSetContainer((InternalEObject)newRepository__Interface, RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE, msgs);
		return msgs;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setRepository__Interface(Repository newRepository__Interface)
	{
		eDynamicSet(RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE, RepositoryPackage.Literals.INTERFACE__REPOSITORY_INTERFACE, newRepository__Interface);
	}

	/**
	 * The cached invocation delegate for the '{@link #isAssignableFrom(org.palladiosimulator.pcm.repository.Interface) <em>Is Assignable From</em>}' operation.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @see #isAssignableFrom(org.palladiosimulator.pcm.repository.Interface)
	 * @generated
	 * @ordered
	 */
	protected static final EOperation.Internal.InvocationDelegate IS_ASSIGNABLE_FROM_INTERFACE__EINVOCATION_DELEGATE = ((EOperation.Internal)RepositoryPackage.Literals.INTERFACE.getEOperations().get(0)).getInvocationDelegate();

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isAssignableFrom(Interface otherInterface)
	{
		try
		{
			return (Boolean)IS_ASSIGNABLE_FROM_INTERFACE__EINVOCATION_DELEGATE.dynamicInvoke(this, new BasicEList.UnmodifiableEList<Object>(1, new Object[]{otherInterface}));
		}
		catch (InvocationTargetException ite)
		{
			throw new WrappedException(ite);
		}
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				return ((InternalEList<InternalEObject>)(InternalEList<?>)getRequiredCharacterisations()).basicAdd(otherEnd, msgs);
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				if (eInternalContainer() != null)
					msgs = eBasicRemoveFromContainer(msgs);
				return basicSetRepository__Interface((Repository)otherEnd, msgs);
		}
		return super.eInverseAdd(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, NotificationChain msgs)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE:
				return ((InternalEList<?>)getProtocols__Interface()).basicRemove(otherEnd, msgs);
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				return ((InternalEList<?>)getRequiredCharacterisations()).basicRemove(otherEnd, msgs);
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				return basicSetRepository__Interface(null, msgs);
		}
		return super.eInverseRemove(otherEnd, featureID, msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public NotificationChain eBasicRemoveFromContainerFeature(NotificationChain msgs)
	{
		switch (eContainerFeatureID())
		{
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				return eInternalContainer().eInverseRemove(this, RepositoryPackage.REPOSITORY__INTERFACES_REPOSITORY, Repository.class, msgs);
		}
		return super.eBasicRemoveFromContainerFeature(msgs);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object eGet(int featureID, boolean resolve, boolean coreType)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__PARENT_INTERFACES_INTERFACE:
				return getParentInterfaces__Interface();
			case RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE:
				return getProtocols__Interface();
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				return getRequiredCharacterisations();
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				return getRepository__Interface();
		}
		return super.eGet(featureID, resolve, coreType);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@SuppressWarnings("unchecked")
	@Override
	public void eSet(int featureID, Object newValue)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__PARENT_INTERFACES_INTERFACE:
				getParentInterfaces__Interface().clear();
				getParentInterfaces__Interface().addAll((Collection<? extends Interface>)newValue);
				return;
			case RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE:
				getProtocols__Interface().clear();
				getProtocols__Interface().addAll((Collection<? extends Protocol>)newValue);
				return;
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				getRequiredCharacterisations().clear();
				getRequiredCharacterisations().addAll((Collection<? extends RequiredCharacterisation>)newValue);
				return;
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				setRepository__Interface((Repository)newValue);
				return;
		}
		super.eSet(featureID, newValue);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void eUnset(int featureID)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__PARENT_INTERFACES_INTERFACE:
				getParentInterfaces__Interface().clear();
				return;
			case RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE:
				getProtocols__Interface().clear();
				return;
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				getRequiredCharacterisations().clear();
				return;
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				setRepository__Interface((Repository)null);
				return;
		}
		super.eUnset(featureID);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean eIsSet(int featureID)
	{
		switch (featureID)
		{
			case RepositoryPackage.INTERFACE__PARENT_INTERFACES_INTERFACE:
				return !getParentInterfaces__Interface().isEmpty();
			case RepositoryPackage.INTERFACE__PROTOCOLS_INTERFACE:
				return !getProtocols__Interface().isEmpty();
			case RepositoryPackage.INTERFACE__REQUIRED_CHARACTERISATIONS:
				return !getRequiredCharacterisations().isEmpty();
			case RepositoryPackage.INTERFACE__REPOSITORY_INTERFACE:
				return getRepository__Interface() != null;
		}
		return super.eIsSet(featureID);
	}

} //InterfaceImpl
