/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.pcm.stoex.ui.contentassist;

import com.google.inject.Inject;
import de.uka.ipd.sdq.stoex.NamespaceReference;
import de.uka.ipd.sdq.stoex.RandomVariable;
import de.uka.ipd.sdq.stoex.VariableReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.xtext.Assignment;
import org.eclipse.xtext.Keyword;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.ui.editor.contentassist.ContentAssistContext;
import org.eclipse.xtext.ui.editor.contentassist.ICompletionProposalAcceptor;
import org.palladiosimulator.commons.stoex.services.StoexContext;
import org.palladiosimulator.commons.stoex.services.StoexContextProvider;
import org.palladiosimulator.pcm.core.entity.NamedElement;
import org.palladiosimulator.pcm.parameter.CharacterisedVariable;
import org.palladiosimulator.pcm.repository.CollectionDataType;
import org.palladiosimulator.pcm.repository.CompositeDataType;
import org.palladiosimulator.pcm.repository.DataType;
import org.palladiosimulator.pcm.repository.EventType;
import org.palladiosimulator.pcm.repository.InnerDeclaration;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.repository.Parameter;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ExternalCallAction;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.pcm.stoex.ui.contentassist.AbstractPCMStoexProposalProvider;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;

public class PCMStoexProposalProvider
extends AbstractPCMStoexProposalProvider {
    @Inject
    private StoexContextProvider contextProvider;

    @Override
    public void completeCharacterisedVariable_Id_Variable(EObject model, Assignment assignment, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.completeCharacterisedVariable_Id_Variable(model, assignment, context, acceptor);
        this.getReferenceableVariableCompletions((Resource)context.getResource(), context).forEach(arg_0 -> ((ICompletionProposalAcceptor)acceptor).accept(arg_0));
    }

    public void complete_VariableReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_VariableReference(model, ruleCall, context, acceptor);
        if (this.lastKeywordWasStop(context)) {
            acceptor.accept(this.createCompletionProposal("BYTESIZE", "BYTESIZE - Characterise the memory footprint in bytes", null, context));
            acceptor.accept(this.createCompletionProposal("NUMBER_OF_ELEMENTS", "NUMBER_OF_ELEMENTS - Characterise the number of elements of a collection datatype", null, context));
            acceptor.accept(this.createCompletionProposal("STRUCTURE", "STRUCTURE - Characterise the structure of a datastructure", null, context));
            acceptor.accept(this.createCompletionProposal("VALUE", "VALUE - Characterise the actual value of a variable", null, context));
            acceptor.accept(this.createCompletionProposal("TYPE", "TYPE - Characterise the type of a variable", null, context));
        }
    }

    public void complete_NamespaceReference(EObject model, RuleCall ruleCall, ContentAssistContext context, ICompletionProposalAcceptor acceptor) {
        super.complete_NamespaceReference(model, ruleCall, context, acceptor);
        Optional<INode> currentNode = Optional.ofNullable(context.getCurrentNode());
        Optional<EObject> currentSemantic = Optional.ofNullable(context.getCurrentNode()).map(INode::getSemanticElement);
        Optional<CharacterisedVariable> currentCharacterisedVariable = this.cast(currentSemantic, CharacterisedVariable.class);
        Optional<VariableReference> currentVariableReference = this.cast(currentSemantic, VariableReference.class);
        Optional<String> previousText = currentNode.map(INode::getPreviousSibling).map(INode::getText);
        StoexContext stoexContext = this.contextProvider.getContext((Resource)context.getResource());
        List<Object> referenceParts = new ArrayList();
        if (currentCharacterisedVariable.isPresent() && previousText.isPresent()) {
            referenceParts = Arrays.asList(previousText.get().split("\\."));
        } else if (currentVariableReference.isPresent()) {
            EObject current = (EObject)currentVariableReference.get();
            while (current.eContainer() instanceof NamespaceReference) {
                current = current.eContainer();
                referenceParts.add(((NamespaceReference)current).getReferenceName());
            }
            Collections.reverse(referenceParts);
        }
        if (!referenceParts.isEmpty()) {
            String parameterName = (String)referenceParts.get(0);
            Collection<Parameter> parameters = this.findServiceParameters(stoexContext);
            Optional<Parameter> parameter = parameters.stream().filter(p -> p.getParameterName().equals(parameterName)).findFirst();
            if (parameter.isEmpty()) {
                return;
            }
            Object currentDataType = parameter.get().getDataType__Parameter();
            int i = 1;
            while (i < referenceParts.size()) {
                String part = (String)referenceParts.get(i);
                currentDataType = currentDataType instanceof CollectionDataType && "INNER".equals(part) ? ((CollectionDataType)currentDataType).getInnerType_CollectionDataType() : (currentDataType instanceof CompositeDataType ? (DataType)((CompositeDataType)currentDataType).getInnerDeclaration_CompositeDataType().stream().filter(d -> part.equals(d.getEntityName())).map(InnerDeclaration::getDatatype_InnerDeclaration).findFirst().orElse(null) : null);
                ++i;
            }
            if (currentDataType instanceof CollectionDataType) {
                acceptor.accept(this.createCompletionProposal("INNER", "INNER - inner data type", null, context));
            } else if (currentDataType instanceof CompositeDataType) {
                ((CompositeDataType)currentDataType).getInnerDeclaration_CompositeDataType().stream().map(NamedElement::getEntityName).forEach(name -> acceptor.accept(this.createCompletionProposal((String)name, String.valueOf(name) + " - inner declaration", null, context)));
            }
        }
    }

    protected <T> Optional<T> cast(Optional<?> optional, Class<T> clazz) {
        return optional.filter(clazz::isInstance).map(clazz::cast);
    }

    protected boolean lastKeywordWasStop(ContentAssistContext context) {
        return Optional.ofNullable(context.getLastCompleteNode()).map(INode::getGrammarElement).filter(Keyword.class::isInstance).map(Keyword.class::cast).map(Keyword::getValue).map("."::equals).orElse(false);
    }

    protected Collection<ICompletionProposal> getReferenceableVariableCompletions(Resource resource, ContentAssistContext cac) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>();
        StoexContext context = this.contextProvider.getContext(resource);
        Optional container = context.getContainer();
        this.findServiceParameters(context).stream().map(Parameter::getParameterName).map(name -> this.createCompletionProposal((String)name, String.valueOf(name) + " - Signature Parameter", null, cac)).forEach(proposals::add);
        Optional<EntryLevelSystemCall> elscAction = container.flatMap(c -> PCMStoexProposalProvider.findSelfOrParentOfType((EObject)c, AbstractUserAction.class)).filter(EntryLevelSystemCall.class::isInstance).map(EntryLevelSystemCall.class::cast);
        if (elscAction.isPresent() && container.isPresent()) {
            EntryLevelSystemCall elsc = elscAction.get();
            RandomVariable rv = (RandomVariable)container.get();
            boolean isOutputCharacterisation = elsc.getOutputParameterUsages_EntryLevelSystemCall().stream().anyMatch(vu -> EcoreUtil.isAncestor((EObject)vu, (EObject)rv));
            if (isOutputCharacterisation) {
                proposals.add(this.createCompletionProposal("RETURN", "RETURN - Call Result", null, cac));
            }
        }
        Optional<ExternalCallAction> ecaAction = container.flatMap(c -> PCMStoexProposalProvider.findSelfOrParentOfType((EObject)c, AbstractAction.class)).filter(ExternalCallAction.class::isInstance).map(ExternalCallAction.class::cast);
        if (ecaAction.isPresent() && container.isPresent()) {
            ExternalCallAction eca = ecaAction.get();
            RandomVariable rv = (RandomVariable)container.get();
            boolean isOutputCharacterisation = eca.getReturnVariableUsage__CallReturnAction().stream().anyMatch(vu -> EcoreUtil.isAncestor((EObject)vu, (EObject)rv));
            if (isOutputCharacterisation) {
                proposals.add(this.createCompletionProposal("RETURN", "RETURN - Call Result", null, cac));
            }
        }
        return proposals;
    }

    protected Collection<Parameter> findServiceParameters(StoexContext context) {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        Optional<Signature> signature = context.getContainer().flatMap(c -> PCMStoexProposalProvider.findSelfOrParentOfType((EObject)c, ServiceEffectSpecification.class)).map(ServiceEffectSpecification::getDescribedService__SEFF);
        Optional<OperationSignature> operationalSignature = signature.filter(OperationSignature.class::isInstance).map(OperationSignature.class::cast);
        operationalSignature.map(OperationSignature::getParameters__OperationSignature).ifPresent(parameters::addAll);
        Optional<EventType> eventType = signature.filter(EventType.class::isInstance).map(EventType.class::cast);
        eventType.map(EventType::getParameter__EventType).ifPresent(parameters::add);
        return parameters;
    }

    protected static <T> Optional<T> findSelfOrParentOfType(EObject self, Class<T> wantedType) {
        EObject current = self;
        while (current != null) {
            if (wantedType.isInstance(current)) {
                return Optional.of(current);
            }
            current = current.eContainer();
        }
        return Optional.empty();
    }
}

