package org.palladiosimulator.pcm.ui.provider.categoryaware;


import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandParameter;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;

/**
 * @author Snowball
 * Pseudo item provider for category displays - No EMF Model Element is associated to this type of item provider.
 * The idea is to insert item providers into the tree of model objects which are
 * actually not associated to model objects and are only used for display/GUI
 * reasons. Those providers filter the children of their parent node according
 * to their category. The idea is inspired by the EMF bible, chapter 14, where
 * a similar approach is presented. The class is partially generated by using
 * "Generate delegator" on the type ItemProviderAdapter. Note that most calls are delegated
 * to our parent node, as this is the "real" model object and not a pseudo node as we are....
 *
 */
public class GenericCategoryItemProvider extends ItemProviderAdapter
implements 	IEditingDomainItemProvider,
	IStructuredItemContentProvider,
	ITreeItemContentProvider,
	IItemLabelProvider,
	IItemPropertySource,
	IDisposable,
	Adapter
{
	private CategoryDescriptor descriptor;
	
	/**
	 * Default constructor
	 * @param adapterFactory The adapter factory which can be used to generate ItemProviders
	 * for child elements, labels, ...
	 * @param descriptor A category descriptor characterising the filter which is used to
	 * select the child elements of the parent
	 * @param parentObject The parent (model) object whose children should be displayed using
	 * several categories
	 */
	public GenericCategoryItemProvider(AdapterFactory adapterFactory, CategoryDescriptor descriptor, EObject parentObject) {
		super(adapterFactory);
		parentObject.eAdapters().add(this);
		this.descriptor = descriptor;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getChildren(java.lang.Object)
	 * Delegate this call to our parent object, which works because the parent calls
	 * getChildReferences() to actually retrieve the children. See EMF.Edit documentation or 
	 * the EMF bible for the sequence of calls...
	 */
	public Collection getChildren(Object object)
	{
		return super.getChildren(target);
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getParent(java.lang.Object)
	 * The parent of all category items is the parent model element
	 */
	public Object getParent(Object object)
	{
		return target;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getChildrenReferences(java.lang.Object)
	 * The only children to be displayed are those which fit to the eReference (category) given
	 * in its category desriptor
	 */
	@Override
	protected Collection getChildrenReferences(Object object) {
		if (childrenReferences == null)
		{
			super.getChildrenReferences(object);
			childrenReferences.add(descriptor.getEReference());
		}
		return childrenReferences;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getText(java.lang.Object)
	 * Get the label from the decriptor object
	 */
	public String getText(Object object)
	{
		return descriptor.getLabel();
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.common.notify.impl.AdapterImpl#notifyChanged(org.eclipse.emf.common.notify.Notification)
	 * We are only concerned with notifications which affect our category, filter out all others
	 */
	public void notifyChanged(Notification notification)
	{
		if (notification.getFeatureID(descriptor.getParentClass()) == descriptor.getEReference().getFeatureID()){
			fireNotifyChanged(new NotificationWrapper(this,notification));
		}
	}
	
	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#dispose()
	 */
	@Override
	public void dispose() {
		target.eAdapters().remove(this);
		super.dispose();
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getNewChildDescriptors(java.lang.Object, org.eclipse.emf.edit.domain.EditingDomain, java.lang.Object)
	 * Filter the child descriptors of our parent node in a way that only those decriptors
	 * matching our category are left over
	 */
	@Override
	public Collection getNewChildDescriptors(Object object, EditingDomain editingDomain, Object sibling) {
		IEditingDomainItemProvider itemProvider = 
			(IEditingDomainItemProvider)adapterFactory.adapt((Object)target, IEditingDomainItemProvider.class);
		Collection children = itemProvider.getNewChildDescriptors(target, editingDomain, sibling);
		ArrayList result = new ArrayList();
		for (Iterator i=children.iterator(); i.hasNext(); )
		{
			CommandParameter p = (CommandParameter)i.next();
			if (p.getEReference() != null && p.getEReference() == descriptor.getEReference())
			{
				result.add(p);
			}
		}
		return result;
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getCreateChildDescription(java.lang.Object, java.lang.Object, java.lang.Object, java.util.Collection)
	 */
	@Override
	public String getCreateChildDescription(Object owner, Object feature, Object child, Collection selection) {
		// TODO Auto-generated method stub
		return super.getCreateChildDescription(target, feature, child, selection);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getCreateChildImage(java.lang.Object, java.lang.Object, java.lang.Object, java.util.Collection)
	 */
	@Override
	public Object getCreateChildImage(Object owner, Object feature, Object child, Collection selection) {
		// TODO Auto-generated method stub
		return super.getCreateChildImage(target, feature, child, selection);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getCreateChildResult(java.lang.Object)
	 */
	@Override
	public Collection getCreateChildResult(Object child) {
		// TODO Auto-generated method stub
		return super.getCreateChildResult(child);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getCreateChildText(java.lang.Object, java.lang.Object, java.lang.Object, java.util.Collection)
	 */
	@Override
	public String getCreateChildText(Object owner, Object feature, Object child, Collection selection) {
		// TODO Auto-generated method stub
		return super.getCreateChildText(target, feature, child, selection);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#getCreateChildToolTipText(java.lang.Object, java.lang.Object, java.lang.Object, java.util.Collection)
	 */
	@Override
	public String getCreateChildToolTipText(Object owner, Object feature, Object child, Collection selection) {
		// TODO Auto-generated method stub
		return super.getCreateChildToolTipText(target, feature, child, selection);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.emf.edit.provider.ItemProviderAdapter#createCommand(java.lang.Object, org.eclipse.emf.edit.domain.EditingDomain, java.lang.Class, org.eclipse.emf.edit.command.CommandParameter)
	 */
	@Override
	public Command createCommand(Object object, EditingDomain domain, Class commandClass, CommandParameter commandParameter) {
		IEditingDomainItemProvider itemProvider = 
			(IEditingDomainItemProvider)adapterFactory.adapt((Object)target, IEditingDomainItemProvider.class);
		return itemProvider.createCommand(target, domain, commandClass, commandParameter);
	}
}
