/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;

public enum CalculatorFactoryRegistryExtensionPoint {
    INSTANCE;

    public static final String METRIC_ATTRIBUTE = "metricId";
    public static final String FACTORY_ATTRIBUTE = "factoryClass";
    public static final String EXTENSION_POINT_ID = "org.palladiosimulator.probeframework.calculator.factories";
    private static final Logger LOGGER;

    static {
        LOGGER = Logger.getLogger(CalculatorFactoryRegistryExtensionPoint.class);
    }

    public Map<String, IGenericCalculatorFactory> getCalculatorFactories() {
        HashMap<String, IGenericCalculatorFactory> result = new HashMap<String, IGenericCalculatorFactory>();
        IConfigurationElement[] iConfigurationElementArray = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT_ID);
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement config = iConfigurationElementArray[n2];
            String metricId = config.getAttribute(METRIC_ATTRIBUTE);
            if (result.containsKey(metricId)) {
                LOGGER.error((Object)String.format("Duplicate calculator factory registered for metric id %s. Ignoring the one provided by: %s", metricId, config.getContributor().getName()));
            } else {
                try {
                    Object fact = config.createExecutableExtension(FACTORY_ATTRIBUTE);
                    if (fact instanceof IGenericCalculatorFactory) {
                        result.put(metricId, (IGenericCalculatorFactory)fact);
                    } else {
                        LOGGER.error((Object)String.format("Calculator registered by %s for metric id %s does not conform to type %s", config.getContributor().getName(), metricId, IGenericCalculatorFactory.class.getName()));
                    }
                }
                catch (CoreException e) {
                    LOGGER.error((Object)String.format("Failed to instantiate the factory registered by %s for metric id %s", config.getContributor().getName(), metricId));
                }
            }
            ++n2;
        }
        return result;
    }
}

