/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator.internal;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.probes.Probe;

public class TimeSpanCalculator
extends Calculator {
    public TimeSpanCalculator(MetricDescription metricDescription, MeasuringPoint measuringPoint, List<Probe> probes) {
        super(metricDescription, measuringPoint, probes);
    }

    @Override
    protected MeasuringValue calculate(List<ProbeMeasurement> probeMeasurements) {
        ArrayList<Object> result = new ArrayList<Object>(2);
        Measure startTimeMeasure = probeMeasurements.get(0).getMeasureProvider().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure endTimeMeasure = probeMeasurements.get(1).getMeasureProvider().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        double timeSpan = endTimeMeasure.doubleValue((Unit)SI.SECOND) - startTimeMeasure.doubleValue((Unit)SI.SECOND);
        Measure timeSpanMeasure = Measure.valueOf((double)timeSpan, (Unit)SI.SECOND);
        MeasuringValue endTimeMeasurement = probeMeasurements.get(1).getBasicMeasurement().getMeasuringValueForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        result.add(endTimeMeasurement);
        BasicMeasurement timeSpanMeasurement = new BasicMeasurement(timeSpanMeasure, (BaseMetricDescription)((MetricSetDescription)this.getMetricDesciption()).getSubsumedMetrics().get(1));
        result.add(timeSpanMeasurement);
        return new TupleMeasurement(result, (MetricSetDescription)this.getMetricDesciption());
    }
}

