/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.measurementframework.listener.MeasurementSource;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.exceptions.CalculatorException;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.probeframework.probes.listener.IProbeListener;

public abstract class Calculator
extends MeasurementSource
implements IProbeListener {
    private static final Logger LOGGER = Logger.getLogger(Calculator.class);
    protected final List<Probe> probes;
    private final Map<RequestContext, List<ProbeMeasurement>> arrivedMeasurementMemory;
    private final MeasuringPoint measuringPoint;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getMetricDesciption() == null ? 0 : this.getMetricDesciption().getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Calculator other = (Calculator)obj;
        if (this.getMetricDesciption() == null ? other.getMetricDesciption() != null : !this.isCompatibleWith(other.getMetricDesciption())) {
            return false;
        }
        return !(this.measuringPoint == null ? other.measuringPoint != null : !EcoreUtil.equals((EObject)this.measuringPoint, (EObject)other.measuringPoint));
    }

    protected Calculator(MetricDescription computedMetric, MeasuringPoint measuringPoint, List<Probe> childProbes) {
        super(computedMetric);
        this.measuringPoint = measuringPoint;
        this.arrivedMeasurementMemory = new HashMap<RequestContext, List<ProbeMeasurement>>();
        this.probes = Collections.unmodifiableList(new ArrayList<Probe>(childProbes));
        for (Probe probe : childProbes) {
            probe.addObserver(this);
        }
    }

    protected abstract MeasuringValue calculate(List<ProbeMeasurement> var1) throws CalculatorException;

    public MeasuringPoint getMeasuringPoint() {
        return this.measuringPoint;
    }

    public void preUnregister() {
        for (Probe probe : this.probes) {
            probe.removeObserver(this);
        }
        for (IMeasurementSourceListener l : this.getMeasurementSourceListeners()) {
            l.preUnregister();
            this.removeObserver(l);
        }
    }

    @Override
    public void newProbeMeasurementAvailable(ProbeMeasurement probeMeasurement) {
        List<ProbeMeasurement> measurementMemory;
        if (!this.probes.contains(probeMeasurement.getProbeAndContext().getProbe())) {
            throw new IllegalArgumentException("Received a probe measurement from a probe not known to this calculator");
        }
        if (this.isMeasurementFromFirstProbe(probeMeasurement)) {
            if (this.arrivedMeasurementMemory.containsKey(probeMeasurement.getProbeAndContext().getRequestContext())) {
                throw new IllegalStateException("First measurement to the same context arrived while previous series of the same context did not complete.");
            }
            this.arrivedMeasurementMemory.put(probeMeasurement.getProbeAndContext().getRequestContext(), new LinkedList());
        }
        if ((measurementMemory = this.arrivedMeasurementMemory.get(probeMeasurement.getProbeAndContext().getRequestContext())) == null) {
            LOGGER.error((Object)("Could not match probe measurement " + probeMeasurement.toString() + " with existing results in Calculator.java, altough there should be previous " + "results already available. This may happen if you, for example, have a passive " + "resource of capacity > 1 that is acquired in one thread and released in another. " + "In that case, holding time cannot be determined as SimuCom does not use something " + "like coloured tokens. Be advised that the sensor might contain only partial results."));
        } else {
            measurementMemory.add(probeMeasurement);
            if (this.isMeasurementFromLastProbe(probeMeasurement)) {
                this.fireCalculated(measurementMemory);
                this.arrivedMeasurementMemory.remove(probeMeasurement.getProbeAndContext().getRequestContext());
            }
        }
    }

    private void fireCalculated(List<ProbeMeasurement> probeMeasurements) {
        try {
            MeasuringValue calculatedMeasures = this.calculate(probeMeasurements);
            this.notifyMeasurementSourceListener(calculatedMeasures);
        }
        catch (CalculatorException e) {
            LOGGER.error((Object)e);
            throw new RuntimeException(e);
        }
    }

    private boolean isMeasurementFromLastProbe(ProbeMeasurement probeMeasurement) {
        return probeMeasurement.getProbeAndContext().getProbe() == this.probes.get(this.probes.size() - 1);
    }

    private boolean isMeasurementFromFirstProbe(ProbeMeasurement probeMeasurement) {
        return probeMeasurement.getProbeAndContext().getProbe() == this.probes.get(0);
    }
}

