/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator;

import java.util.List;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.ICalculatorFactory;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

public interface ICalculatorFactoryLegacyAdapter
extends ICalculatorFactory,
IGenericCalculatorFactory {
    public static ICalculatorFactoryLegacyAdapter createDelegatingAdapter(IGenericCalculatorFactory delegate) {
        return delegate::buildCalculator;
    }

    @Override
    default public Calculator buildResponseTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration(probes.get(0), probes.get(1)));
    }

    @Override
    default public Calculator buildDemandBasedWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.buildWaitingTimeCalculator(measuringPoint, probes);
    }

    @Override
    default public Calculator buildWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration(probes.get(0), probes.get(1)));
    }

    @Override
    default public Calculator buildHoldingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration(probes.get(0), probes.get(1)));
    }

    @Override
    default public Calculator buildStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildOverallStateOfActiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.OVERALL_STATE_OF_ACTIVE_RESOURCE_METRIC, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildOverallStateOfPassiveResourceCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.OVERALL_STATE_OF_PASSIVE_RESOURCE_METRIC, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildResourceDemandCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.RESOURCE_DEMAND_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildExecutionResultCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator(probe.getMetricDesciption(), measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildNumberOfResourceContainersCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildReconfigurationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.RECONFIGURATION_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildCostOverTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.COST_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildAggregatedCostOverTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.AGGREGATED_COST_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }

    @Override
    default public Calculator buildOptimisationTimeCalculator(MeasuringPoint measuringPoint, Probe probe) {
        return this.buildCalculator((MetricDescription)MetricDescriptionConstants.OPTIMISATION_TIME_METRIC_TUPLE, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration(probe));
    }
}

