/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator.internal;

import java.util.ArrayList;
import java.util.List;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.BasicMeasurement;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.probeframework.calculator.internal.WaitingTimeCalculator;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.probes.Probe;

public class DemandBasedWaitingTimeCalculator
extends WaitingTimeCalculator {
    public DemandBasedWaitingTimeCalculator(MeasuringPoint measuringPoint, List<Probe> probes) {
        super(measuringPoint, probes);
    }

    @Override
    protected MeasuringValue calculate(List<ProbeMeasurement> probeMeasurements) {
        Measure startTimeMeasure = probeMeasurements.get(0).getMeasureProvider().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure demandMeasure = probeMeasurements.get(0).getMeasureProvider().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.RESOURCE_DEMAND_METRIC);
        Measure endTimeMeasure = probeMeasurements.get(1).getMeasureProvider().getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        double timeSpan = endTimeMeasure.doubleValue((Unit)SI.SECOND) - startTimeMeasure.doubleValue((Unit)SI.SECOND);
        double waitingTime = timeSpan - demandMeasure.doubleValue((Unit)SI.SECOND);
        if (waitingTime < 0.0) {
            waitingTime = 0.0;
        }
        Measure waitingTimeMeasure = Measure.valueOf((double)waitingTime, (Unit)SI.SECOND);
        ArrayList<Object> result = new ArrayList<Object>(2);
        BasicMeasurement waitingTimeMeasurement = new BasicMeasurement(waitingTimeMeasure, MetricDescriptionConstants.WAITING_TIME_METRIC);
        result.add(probeMeasurements.get(1).getBasicMeasurement().getMeasuringValueForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC));
        result.add(waitingTimeMeasurement);
        return new TupleMeasurement(result, (MetricSetDescription)this.getMetricDesciption());
    }
}

