/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.probeframework.calculator.internal;

import java.util.List;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.TupleMeasurement;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.measurementframework.measureprovider.MeasurementListMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.probeframework.calculator.internal.UnaryCalculator;
import org.palladiosimulator.probeframework.exceptions.CalculatorException;
import org.palladiosimulator.probeframework.measurement.ProbeMeasurement;
import org.palladiosimulator.probeframework.probes.Probe;

public class IdentityCalculator
extends UnaryCalculator {
    public IdentityCalculator(MeasuringPoint measuringPoint, Probe probe) {
        super(probe.getMetricDesciption(), measuringPoint, probe);
    }

    public IdentityCalculator(MetricDescription metricDescription, MeasuringPoint measuringPoint, Probe probe) {
        this(measuringPoint, probe);
        if (!this.isCompatibleWith(metricDescription)) {
            throw new RuntimeException("Identiy calculator attached to a probe with a different metric description as the probe itself.");
        }
    }

    @Override
    protected MeasuringValue calculate(List<ProbeMeasurement> probeMeasurements) throws CalculatorException {
        MetricSetDescription metricSetDescription = (MetricSetDescription)this.getMetricDesciption();
        IMeasureProvider measureProvider = probeMeasurements.get(0).getMeasureProvider();
        if (!(measureProvider instanceof MeasurementListMeasureProvider)) {
            throw new CalculatorException("Measure provider used within identity calculators have to be of type MeasurementListMeasureProvider");
        }
        List measurements = ((MeasurementListMeasureProvider)measureProvider).getSubsumedMeasurements();
        return new TupleMeasurement(measurements, metricSetDescription);
    }
}

