/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.main;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import de.uka.ipd.sdq.probfunction.math.IProbabilityFunctionFactory;
import de.uka.ipd.sdq.probfunction.math.IRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.DefaultRandomGenerator;
import de.uka.ipd.sdq.probfunction.math.impl.ProbabilityFunctionFactoryImpl;
import de.uka.ipd.sdq.simucomframework.variables.cache.StoExCache;
import java.io.IOException;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.palladiosimulator.protocom.framework.java.ee.main.ProtoComModule;
import org.palladiosimulator.protocom.framework.java.ee.main.WebAppender;
import org.palladiosimulator.protocom.framework.java.ee.protocol.Registry;
import org.palladiosimulator.protocom.framework.java.ee.prototype.PrototypeBridge;

@WebServlet(value={""})
public abstract class MainServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getRootLogger();
    private static DefaultRandomGenerator generator;
    private boolean firstRequest = true;

    static {
        MainServlet.initStoEx();
    }

    public static void setStoExSeed(long seed) {
        generator.setSeed(Long.valueOf(seed));
    }

    public MainServlet() {
        LOGGER.removeAllAppenders();
        LOGGER.addAppender((Appender)new WebAppender());
        LOGGER.setLevel(Level.INFO);
        Injector injector = Guice.createInjector((Module[])new Module[]{new ProtoComModule()});
        PrototypeBridge bridge = (PrototypeBridge)injector.getInstance(PrototypeBridge.class);
        this.initPrototype(bridge);
    }

    protected abstract void initPrototype(PrototypeBridge var1);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (this.firstRequest) {
            Registry.getInstance().setLocation(request.getRequestURL().toString());
            this.firstRequest = false;
        }
        RequestDispatcher dispatcher = request.getRequestDispatcher("jsp/Main.jsp");
        dispatcher.forward((ServletRequest)request, (ServletResponse)response);
    }

    private static void initStoEx() {
        generator = new DefaultRandomGenerator();
        ProbabilityFunctionFactoryImpl factory = ProbabilityFunctionFactoryImpl.getInstance();
        factory.setRandomGenerator((IRandomGenerator)generator);
        StoExCache.initialiseStoExCache((IProbabilityFunctionFactory)factory);
    }
}

