/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.protocol;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.util.LinkedHashMap;

public class RemoteCall {
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private String name;
    private Class<?>[] formalTypes;
    private Class<?>[] actualTypes;
    private Object[] arguments;

    static {
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
    }

    public RemoteCall() {
    }

    public RemoteCall(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?>[] getFormalTypes() {
        return this.formalTypes;
    }

    public void setFormalTypes(Class<?>[] formalTypes) {
        this.formalTypes = formalTypes;
    }

    public Class<?>[] getActualTypes() {
        return this.actualTypes;
    }

    public void setActualTypes(Class<?>[] actualTypes) {
        this.actualTypes = actualTypes;
    }

    public Object[] getArguments() {
        return this.arguments;
    }

    public void setArguments(Object[] arguments) {
        this.arguments = arguments;
    }

    public void dispatch(Object target) {
        try {
            target.getClass().getMethod(this.name, this.formalTypes).invoke(target, this.arguments);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String toJson() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static RemoteCall fromJson(String serialized) {
        try {
            RemoteCall call = (RemoteCall)MAPPER.readValue(serialized, RemoteCall.class);
            if (call.getArguments() != null) {
                int i = 0;
                while (i < call.arguments.length) {
                    if (call.arguments[i] instanceof LinkedHashMap) {
                        call.arguments[i] = MAPPER.convertValue(call.arguments[i], call.actualTypes[i]);
                    }
                    ++i;
                }
            }
            return call;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

