/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.ee.protocol;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.palladiosimulator.protocom.framework.java.ee.protocol.Parameter;

public class Request {
    public static void post(String location, String path, String body) {
        DefaultHttpClient client = new DefaultHttpClient();
        HttpPost post = new HttpPost(String.valueOf(location) + path);
        post.setHeader("Content-Type", "application/json");
        try {
            post.setEntity((HttpEntity)new StringEntity(body));
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            client.execute((HttpUriRequest)post);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String get(String location, String path, List<Parameter> parameters) {
        HttpGet get = null;
        StringWriter response = new StringWriter();
        DefaultHttpClient client = new DefaultHttpClient();
        try {
            StringBuilder uri = new StringBuilder();
            int i = 0;
            uri.append(location);
            uri.append(path);
            for (Parameter parameter : parameters) {
                String name = URLEncoder.encode(parameter.getName(), "UTF-8");
                String value = URLEncoder.encode(parameter.getValue(), "UTF-8");
                if (i == 0) {
                    uri.append('?');
                } else {
                    uri.append('&');
                }
                uri.append(name);
                uri.append("=");
                uri.append(value);
                ++i;
            }
            get = new HttpGet(uri.toString());
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        try {
            HttpResponse stream = client.execute(get);
            IOUtils.copy((InputStream)stream.getEntity().getContent(), (Writer)response);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return response.toString();
    }
}

