/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.utils;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.log4j.Logger;

public class RunProperties {
    private final CommandLine cmdLine;
    private final Options options;
    private Properties propertyFile = null;
    private static final Logger LOGGER = Logger.getRootLogger();

    public RunProperties(CommandLine cmdLine, Options options) {
        this.cmdLine = cmdLine;
        this.options = options;
        if (cmdLine.hasOption("f")) {
            this.propertyFile = new Properties();
            try {
                this.propertyFile.load(new FileInputStream(cmdLine.getOptionValue("f")));
            }
            catch (FileNotFoundException e) {
                LOGGER.error((Object)"Property file could not be found.", (Throwable)e);
                this.propertyFile = null;
            }
            catch (IOException e) {
                LOGGER.debug((Object)"Error reading property file.", (Throwable)e);
                this.propertyFile = null;
            }
        }
    }

    private String getPropertyFromFile(String key) {
        if (this.propertyFile != null) {
            return this.propertyFile.getProperty(key);
        }
        return null;
    }

    private boolean hasPropertyInFile(String key) {
        if (this.propertyFile != null) {
            return this.propertyFile.getProperty(key) != null;
        }
        return false;
    }

    private String getLongOpt(String opt) {
        String longOpt = opt;
        if (this.options.hasOption(opt)) {
            longOpt = this.options.getOption(opt).getLongOpt();
        }
        return longOpt;
    }

    public String getOptionValue(char opt) {
        String sOpt = "" + opt;
        return this.getOptionValue(sOpt);
    }

    public String getOptionValue(String opt) {
        if (this.cmdLine.hasOption(opt)) {
            return this.cmdLine.getOptionValue(opt);
        }
        String longOpt = this.getLongOpt(opt);
        if (this.hasPropertyInFile(longOpt)) {
            return this.getPropertyFromFile(longOpt);
        }
        return this.cmdLine.getOptionValue(opt);
    }

    public boolean hasOption(char opt) {
        String sOpt = "" + opt;
        return this.hasOption(sOpt);
    }

    public boolean hasOption(String opt) {
        if (this.hasPropertyInFile(this.getLongOpt(opt))) {
            return true;
        }
        return this.cmdLine.hasOption(opt);
    }

    public Object getOptionObject(char opt) {
        String sOpt = "" + opt;
        return this.getOptionObject(sOpt);
    }

    public Object getOptionObject(String opt) {
        return this.cmdLine.getOptionObject(opt);
    }
}

