/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.palladiosimulator.protocom.framework.java.se.ComponentAllocation;

public abstract class AbstractAllocationStorage {
    protected static AbstractAllocationStorage singleton;
    private static Map<String, String> containerIdToName;
    private static Map<String, List<ComponentAllocation>> containerIdToComponents;
    private static String activeContainer;
    private static boolean localMode;

    static {
        containerIdToName = new HashMap<String, String>();
        containerIdToComponents = new HashMap<String, List<ComponentAllocation>>();
        localMode = false;
    }

    protected static void saveContainerComponent(String containerId, String containerName, Class<?> component, String assemblyContext) {
        if (!containerIdToName.containsKey(containerId)) {
            containerIdToName.put(containerId, containerName);
            containerIdToComponents.put(containerId, new LinkedList());
        }
        containerIdToComponents.get(containerId).add(new ComponentAllocation(component, assemblyContext));
    }

    public static String getContainerName(String containerId) {
        return containerIdToName.get(containerId);
    }

    public static String getContainerID(String container) {
        for (Map.Entry<String, String> entry : containerIdToName.entrySet()) {
            if (!entry.getValue().equals(container)) continue;
            return entry.getKey();
        }
        return null;
    }

    public static Collection<String> getContainerIds() {
        return containerIdToName.keySet();
    }

    public static Collection<String> getContainerNames() {
        return containerIdToName.values();
    }

    public static Collection<ComponentAllocation> getComponents(String containerId) {
        return containerIdToComponents.get(containerId);
    }

    protected abstract void initContainerTemplate();

    public static void initContainer() {
        singleton.initContainerTemplate();
    }

    public static void initSingleton(AbstractAllocationStorage instance) {
        singleton = instance;
    }

    public static void setActiveContainer(String containerId) {
        activeContainer = containerId;
    }

    public static String getActiveContainer() {
        if (!localMode) {
            return activeContainer;
        }
        return containerIdToName.entrySet().iterator().next().getKey();
    }

    public static void setLocalMode(boolean localMode) {
        AbstractAllocationStorage.localMode = localMode;
    }

    public static boolean isLocalMode() {
        return localMode;
    }
}

