/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.protocom.framework.java.se.visitor;

import de.uka.ipd.sdq.sensorframework.entities.TimeSpanSensor;
import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.protocom.framework.java.se.experiment.ExperimentManager;
import org.palladiosimulator.protocom.framework.java.se.visitor.ICallVisitor;

public class SensorFrameworkVisitor
implements ICallVisitor {
    private static SensorFrameworkVisitor singleton;
    private Map<String, TimeSpanSensor> sensors = new HashMap<String, TimeSpanSensor>();
    private Map<String, Long> startTimes = new HashMap<String, Long>();

    public static SensorFrameworkVisitor getInstance() {
        if (singleton == null) {
            singleton = new SensorFrameworkVisitor();
        }
        return singleton;
    }

    @Override
    public void preCallVisit(StackContext ctx, String callIdentifier) {
        if (this.sensors.get(callIdentifier) == null) {
            this.sensors.put(callIdentifier, ExperimentManager.createOrReuseTimeSpanSensor(callIdentifier));
        }
        this.startTimes.put(callIdentifier, ExperimentManager.takeStartTimeForInnerMeasurement());
    }

    @Override
    public void postCallVisit(StackContext ctx, String callIdentifier) {
        ExperimentManager.takeMeasurement(this.startTimes.get(callIdentifier), ExperimentManager.getLatestExperimentRun(), this.sensors.get(callIdentifier));
    }
}

