package org.palladiosimulator.protocom.lang.java.util;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.composition.AssemblyEventConnector;
import org.palladiosimulator.pcm.core.composition.AssemblyInfrastructureConnector;
import org.palladiosimulator.pcm.core.composition.ComposedStructure;
import org.palladiosimulator.pcm.core.composition.Connector;
import org.palladiosimulator.pcm.core.composition.DelegationConnector;
import org.palladiosimulator.pcm.core.entity.InterfaceProvidingEntity;
import org.palladiosimulator.pcm.repository.InfrastructureRequiredRole;
import org.palladiosimulator.pcm.repository.OperationRequiredRole;
import org.palladiosimulator.pcm.repository.RequiredRole;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.SinkRole;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.ScenarioBehaviour;

/**
 * Templates for external (service) calls.
 * Converted from PCM's OCL statements.
 * 
 * @author Thomas Zolynski
 */
@SuppressWarnings("all")
public class PcmCalls {
  /**
   * Query System Calls.
   */
  public static Iterable<EntryLevelSystemCall> querySystemCalls(final ScenarioBehaviour scenBe) {
    Set<EntryLevelSystemCall> _xblockexpression = null;
    {
      final LinkedList<EntryLevelSystemCall> results = CollectionLiterals.<EntryLevelSystemCall>newLinkedList();
      final Function1<AbstractUserAction, Boolean> _function = (AbstractUserAction it) -> {
        return Boolean.valueOf(EntryLevelSystemCall.class.isInstance(it));
      };
      final Function1<AbstractUserAction, EntryLevelSystemCall> _function_1 = (AbstractUserAction it) -> {
        return ((EntryLevelSystemCall) it);
      };
      Iterable<EntryLevelSystemCall> _map = IterableExtensions.<AbstractUserAction, EntryLevelSystemCall>map(IterableExtensions.<AbstractUserAction>filter(scenBe.getActions_ScenarioBehaviour(), _function), _function_1);
      Iterables.<EntryLevelSystemCall>addAll(results, _map);
      Iterable<EntryLevelSystemCall> _querySystemCallsInLoops = PcmCalls.querySystemCallsInLoops(scenBe);
      Iterables.<EntryLevelSystemCall>addAll(results, _querySystemCallsInLoops);
      Iterable<EntryLevelSystemCall> _querySystemCallsInBraches = PcmCalls.querySystemCallsInBraches(scenBe);
      Iterables.<EntryLevelSystemCall>addAll(results, _querySystemCallsInBraches);
      _xblockexpression = IterableExtensions.<EntryLevelSystemCall>toSet(results);
    }
    return _xblockexpression;
  }

  public static Iterable<EntryLevelSystemCall> querySystemCallsInLoops(final ScenarioBehaviour sb) {
    final Function1<AbstractUserAction, Boolean> _function = (AbstractUserAction it) -> {
      return Boolean.valueOf(Loop.class.isInstance(it));
    };
    final Function1<AbstractUserAction, Loop> _function_1 = (AbstractUserAction it) -> {
      return ((Loop) it);
    };
    final Function1<Loop, Iterable<EntryLevelSystemCall>> _function_2 = (Loop it) -> {
      return PcmCalls.querySystemCalls(it.getBodyBehaviour_Loop());
    };
    return Iterables.<EntryLevelSystemCall>concat(IterableExtensions.<Loop, Iterable<EntryLevelSystemCall>>map(IterableExtensions.<AbstractUserAction, Loop>map(IterableExtensions.<AbstractUserAction>filter(sb.getActions_ScenarioBehaviour(), _function), _function_1), _function_2));
  }

  public static Iterable<EntryLevelSystemCall> querySystemCallsInBraches(final ScenarioBehaviour scenBe) {
    final Function1<AbstractUserAction, Boolean> _function = (AbstractUserAction it) -> {
      return Boolean.valueOf(Branch.class.isInstance(it));
    };
    final Function1<AbstractUserAction, Branch> _function_1 = (AbstractUserAction it) -> {
      return ((Branch) it);
    };
    final Function1<Branch, EList<BranchTransition>> _function_2 = (Branch it) -> {
      return it.getBranchTransitions_Branch();
    };
    final Function1<BranchTransition, Iterable<EntryLevelSystemCall>> _function_3 = (BranchTransition it) -> {
      return PcmCalls.querySystemCalls(it.getBranchedBehaviour_BranchTransition());
    };
    return Iterables.<EntryLevelSystemCall>concat(IterableExtensions.<BranchTransition, Iterable<EntryLevelSystemCall>>map(Iterables.<BranchTransition>concat(IterableExtensions.<Branch, EList<BranchTransition>>map(IterableExtensions.<AbstractUserAction, Branch>map(IterableExtensions.<AbstractUserAction>filter(scenBe.getActions_ScenarioBehaviour(), _function), _function_1), _function_2)), _function_3));
  }

  public static Iterable<org.palladiosimulator.pcm.system.System> getSystemsFromCalls(final Iterable<EntryLevelSystemCall> calls) {
    final Function1<EntryLevelSystemCall, InterfaceProvidingEntity> _function = (EntryLevelSystemCall it) -> {
      return it.getProvidedRole_EntryLevelSystemCall().getProvidingEntity_ProvidedRole();
    };
    final Function1<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System> _function_1 = (InterfaceProvidingEntity it) -> {
      return ((org.palladiosimulator.pcm.system.System) it);
    };
    return IterableExtensions.<org.palladiosimulator.pcm.system.System>toSet(IterableExtensions.<InterfaceProvidingEntity, org.palladiosimulator.pcm.system.System>map(IterableExtensions.<EntryLevelSystemCall, InterfaceProvidingEntity>map(calls, _function), _function_1));
  }

  /**
   * Query Ports.
   */
  public static CharSequence portQuery(final OperationRequiredRole role, final ComposedStructure s, final AssemblyContext ctx) {
    CharSequence _xifexpression = null;
    boolean _hasConnector = PcmCalls.hasConnector(s, ctx, role);
    if (_hasConnector) {
      CharSequence _xblockexpression = null;
      {
        Connector _connector = PcmCalls.getConnector(s, ctx, role);
        final AssemblyConnector connector = ((AssemblyConnector) _connector);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("(");
        String _fqn = JavaNames.fqn(role.getRequiredInterface__OperationRequiredRole());
        _builder.append(_fqn);
        _builder.append(") my");
        String _javaName = JavaNames.javaName(connector.getProvidingAssemblyContext_AssemblyConnector());
        _builder.append(_javaName);
        _xblockexpression = _builder;
      }
      _xifexpression = _xblockexpression;
    }
    return _xifexpression;
  }

  /**
   * Connectors.
   */
  public static Connector getConnector(final ComposedStructure cs, final AssemblyContext context, final OperationRequiredRole role) {
    final Function1<Connector, Boolean> _function = (Connector con) -> {
      return Boolean.valueOf(PcmCalls.test(con, context, role));
    };
    return ((Connector[])Conversions.unwrapArray(IterableExtensions.<Connector>filter(PcmCalls.connectors(cs), _function), Connector.class))[0];
  }

  public static boolean hasConnector(final ComposedStructure cs, final AssemblyContext context, final OperationRequiredRole role) {
    return true;
  }

  public static Iterable<Connector> connectors(final ComposedStructure s) {
    final Function1<Connector, Boolean> _function = (Connector it) -> {
      boolean _isInstance = DelegationConnector.class.isInstance(it);
      return Boolean.valueOf((!_isInstance));
    };
    return IterableExtensions.<Connector>filter(s.getConnectors__ComposedStructure(), _function);
  }

  protected static boolean _test(final AssemblyConnector c, final AssemblyContext ctx, final RequiredRole r) {
    return (Objects.equal(c.getRequiredRole_AssemblyConnector().getId(), r.getId()) && Objects.equal(c.getRequiringAssemblyContext_AssemblyConnector().getId(), ctx.getId()));
  }

  protected static boolean _test(final AssemblyInfrastructureConnector c, final AssemblyContext ctx, final InfrastructureRequiredRole r) {
    return (Objects.equal(c.getRequiredRole__AssemblyInfrastructureConnector().getId(), r.getId()) && Objects.equal(c.getRequiringAssemblyContext__AssemblyInfrastructureConnector().getId(), ctx.getId()));
  }

  protected static boolean _test(final AssemblyInfrastructureConnector c, final AssemblyContext ctx, final OperationRequiredRole r) {
    return (Objects.equal(c.getRequiredRole__AssemblyInfrastructureConnector().getId(), r.getId()) && Objects.equal(c.getRequiringAssemblyContext__AssemblyInfrastructureConnector().getId(), ctx.getId()));
  }

  protected static boolean _test(final AssemblyEventConnector c, final AssemblyContext ctx, final SinkRole r) {
    return (Objects.equal(c.getSinkRole__AssemblyEventConnector().getId(), r) && Objects.equal(c.getSourceAssemblyContext__AssemblyEventConnector().getId(), ctx.getId()));
  }

  protected static boolean _test(final DelegationConnector c, final AssemblyContext ctx, final SinkRole r) {
    return false;
  }

  public static boolean test(final Connector c, final AssemblyContext ctx, final Role r) {
    if (c instanceof AssemblyEventConnector
         && r instanceof SinkRole) {
      return _test((AssemblyEventConnector)c, ctx, (SinkRole)r);
    } else if (c instanceof AssemblyInfrastructureConnector
         && r instanceof InfrastructureRequiredRole) {
      return _test((AssemblyInfrastructureConnector)c, ctx, (InfrastructureRequiredRole)r);
    } else if (c instanceof AssemblyInfrastructureConnector
         && r instanceof OperationRequiredRole) {
      return _test((AssemblyInfrastructureConnector)c, ctx, (OperationRequiredRole)r);
    } else if (c instanceof DelegationConnector
         && r instanceof SinkRole) {
      return _test((DelegationConnector)c, ctx, (SinkRole)r);
    } else if (c instanceof AssemblyConnector
         && r instanceof RequiredRole) {
      return _test((AssemblyConnector)c, ctx, (RequiredRole)r);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(c, ctx, r).toString());
    }
  }
}
