package org.palladiosimulator.protocom.lang.java.util;

import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.usagemodel.AbstractUserAction;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;
import org.palladiosimulator.pcm.usagemodel.Delay;
import org.palladiosimulator.pcm.usagemodel.EntryLevelSystemCall;
import org.palladiosimulator.pcm.usagemodel.Loop;
import org.palladiosimulator.pcm.usagemodel.Start;
import org.palladiosimulator.pcm.usagemodel.Stop;

/**
 * Defines templates for actions of both kinds: SEFF actions and user actions.
 * 
 * 
 * @author Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PcmStubUserAction extends PcmUserAction {
  /**
   * EntryLevelSystemCall is an user action which calls a system service from an usage scenario.
   */
  @Override
  protected String _userAction(final EntryLevelSystemCall userAction) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("try {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// EntryLevelSystemCall!");
    _builder.newLine();
    _builder.append("\t");
    OperationSignature _operationSignature__EntryLevelSystemCall = userAction.getOperationSignature__EntryLevelSystemCall();
    String _portMemberVar = JavaNames.portMemberVar(userAction.getProvidedRole_EntryLevelSystemCall());
    String _plus = (_portMemberVar + ".");
    String _call = PcmCommons.call(_operationSignature__EntryLevelSystemCall, 
      null, _plus, 
      userAction.getInputParameterUsages_EntryLevelSystemCall(), 
      null);
    _builder.append(_call, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("\t\t\t\t\t\t\t\t");
    _builder.newLine();
    _builder.append("} catch (java.rmi.RemoteException e) {");
    _builder.newLine();
    _builder.append("\t");
    _builder.append("// TODO: Logger!");
    _builder.newLine();
    _builder.append("\t");
    _builder.newLine();
    _builder.append("}");
    _builder.newLine();
    return _builder.toString();
  }

  /**
   * Loop actions are transformed into a simple FOR statement.
   */
  @Override
  protected String _userAction(final Loop userAction) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("// TODO Configure maxIterationCount ");
    _builder.newLine();
    _builder.append("int maxIterationCount");
    String _javaVariableName = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName);
    _builder.append(" = 1;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    _builder.append("for (int iterationCount_");
    String _javaVariableName_1 = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName_1);
    _builder.append(" = 0; ");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    _builder.append("iterationCount_");
    String _javaVariableName_2 = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName_2, "\t");
    _builder.append(" < maxIterationCount_");
    String _javaVariableName_3 = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName_3, "\t");
    _builder.append("; iterationCount_");
    String _javaVariableName_4 = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName_4, "\t");
    _builder.append(" ++) {");
    _builder.newLineIfNotEmpty();
    _builder.append("\t");
    String _userActions = this.userActions(PcmUserAction.findUserStart(userAction.getBodyBehaviour_Loop().getActions_ScenarioBehaviour()));
    _builder.append(_userActions, "\t");
    _builder.newLineIfNotEmpty();
    _builder.append("} ");
    _builder.newLine();
    return _builder.toString();
  }

  /**
   * UserActions only have probabilistic transitions. That might even make sense for test generation
   * for code stubs. Therefore, This might be added here.
   * 
   * TODO Branch user actions are currently not generated with code stubs. AS probabilities make sense here the ctx object might be useful. In any case, for test generation, user actions should be included in future.
   */
  @Override
  protected String _userAction(final Branch userAction) {
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("double u");
    String _javaVariableName = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName);
    _builder.append(" = ctx.evaluate(\"DoublePDF[(1.0;1.0)]\", Double.class);");
    _builder.newLineIfNotEmpty();
    _builder.append("double sum");
    String _javaVariableName_1 = JavaNames.javaVariableName(userAction.getId());
    _builder.append(_javaVariableName_1);
    _builder.append(" = 0;");
    _builder.newLineIfNotEmpty();
    _builder.newLine();
    {
      EList<BranchTransition> _branchTransitions_Branch = userAction.getBranchTransitions_Branch();
      for(final BranchTransition transition : _branchTransitions_Branch) {
        _builder.append("if (sum");
        String _javaVariableName_2 = JavaNames.javaVariableName(userAction.getId());
        _builder.append(_javaVariableName_2);
        _builder.append(" <= u");
        String _javaVariableName_3 = JavaNames.javaVariableName(userAction.getId());
        _builder.append(_javaVariableName_3);
        _builder.append(" && u");
        String _javaVariableName_4 = JavaNames.javaVariableName(userAction.getId());
        _builder.append(_javaVariableName_4);
        _builder.append(" < sum");
        String _javaVariableName_5 = JavaNames.javaVariableName(userAction.getId());
        _builder.append(_javaVariableName_5);
        _builder.append(" + ");
        double _branchProbability = transition.getBranchProbability();
        _builder.append(_branchProbability);
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        String _userActions = this.userActions(PcmUserAction.findUserStart(transition.getBranchedBehaviour_BranchTransition().getActions_ScenarioBehaviour()));
        _builder.append(_userActions, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("}\t");
        _builder.newLine();
        _builder.append("sum");
        String _javaVariableName_6 = JavaNames.javaVariableName(userAction.getId());
        _builder.append(_javaVariableName_6);
        _builder.append(" += ");
        double _branchProbability_1 = transition.getBranchProbability();
        _builder.append(_branchProbability_1);
        _builder.append(";\t");
        _builder.newLineIfNotEmpty();
      }
    }
    return _builder.toString();
  }

  @Override
  public String userAction(final AbstractUserAction userAction) {
    if (userAction instanceof Branch) {
      return _userAction((Branch)userAction);
    } else if (userAction instanceof Delay) {
      return _userAction((Delay)userAction);
    } else if (userAction instanceof EntryLevelSystemCall) {
      return _userAction((EntryLevelSystemCall)userAction);
    } else if (userAction instanceof Loop) {
      return _userAction((Loop)userAction);
    } else if (userAction instanceof Start) {
      return _userAction((Start)userAction);
    } else if (userAction instanceof Stop) {
      return _userAction((Stop)userAction);
    } else {
      throw new IllegalArgumentException("Unhandled parameter types: " +
        Arrays.<Object>asList(userAction).toString());
    }
  }
}
