package org.palladiosimulator.protocom.model.usage;

import java.util.List;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.usagemodel.Branch;
import org.palladiosimulator.pcm.usagemodel.BranchTransition;

/**
 * Adapter class for PCM Branch user actions.
 * @author Christian Klaussner
 */
@SuppressWarnings("all")
public class BranchAdapter extends UserActionAdapter<Branch> {
  public BranchAdapter(final Branch entity) {
    super(entity);
  }

  /**
   * Gets the branch transitions.
   * @return a list of adapters for the branch transitions
   */
  public List<BranchTransitionAdapter> getBranchTransitions() {
    final Function1<BranchTransition, BranchTransitionAdapter> _function = (BranchTransition it) -> {
      return new BranchTransitionAdapter(it);
    };
    return ListExtensions.<BranchTransition, BranchTransitionAdapter>map(this.entity.getBranchTransitions_Branch(), _function);
  }
}
