package org.palladiosimulator.protocom.tech.iiop.repository;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.modelversioning.emfprofileapplication.StereotypeApplication;
import org.palladiosimulator.mdsdprofiles.api.StereotypeAPI;
import org.palladiosimulator.pcm.core.composition.AssemblyConnector;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.iiop.JavaEEIIOPClass;
import org.palladiosimulator.protocom.tech.iiop.util.PcmIIOPProtoAction;

@SuppressWarnings("all")
public class JavaEEIIOPBasicComponentClass extends JavaEEIIOPClass<BasicComponent> {
  private Set<AssemblyConnector> assemblyConnectors;

  public JavaEEIIOPBasicComponentClass(final BasicComponent pcmEntity) {
    super(pcmEntity);
  }

  public JavaEEIIOPBasicComponentClass(final BasicComponent pcmEntity, final Set<AssemblyConnector> assemblyConnectors) {
    super(pcmEntity);
    this.assemblyConnectors = assemblyConnectors;
  }

  @Override
  public Collection<String> interfaces() {
    String _interfaceName = JavaNames.interfaceName(this.pcmEntity);
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_interfaceName));
  }

  @Override
  public String packageName() {
    return JavaNames.fqnJavaEEBasicComponentClassPackage(this.pcmEntity);
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _jMethod = new JMethod();
    JMethod _withParameters = new JMethod().withParameters("String assemblyContextID");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.assemblyContextID = assemblyContextID;");
    _builder.newLine();
    _builder.newLine();
    {
      EList<PassiveResource> _passiveResource_BasicComponent = this.pcmEntity.getPassiveResource_BasicComponent();
      for(final PassiveResource resource : _passiveResource_BasicComponent) {
        _builder.append("passive_resource_");
        String _javaVariableName = JavaNames.javaVariableName(resource.getEntityName());
        _builder.append(_javaVariableName);
        _builder.append(" = new java.util.concurrent.Semaphore(de.uka.ipd.sdq.simucomframework.variables.StackContext.evaluateStatic(\"");
        String _specificationString = JavaNames.specificationString(resource.getCapacity_PassiveResource().getSpecification());
        _builder.append(_specificationString);
        _builder.append("\", Integer.class), true);");
        _builder.newLineIfNotEmpty();
      }
    }
    JMethod _withImplementation = _withParameters.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_jMethod, _withImplementation));
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      JField _withType = new JField().withName("myComponentStackFrame").withType(PcmCommons.stackframeType());
      JField _withType_1 = new JField().withName("myDefaultComponentStackFrame").withType(PcmCommons.stackframeType());
      Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType, _withType_1)));
      JField _withType_2 = new JField().withName("assemblyContextID").withType("String");
      Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType_2)));
      final Function1<PassiveResource, JField> _function = (PassiveResource it) -> {
        JField _jField = new JField();
        String _javaVariableName = JavaNames.javaVariableName(it.getEntityName());
        String _plus = ("passive_resource_" + _javaVariableName);
        return _jField.withName(_plus).withType(
          "java.util.concurrent.Semaphore");
      };
      List<JField> _map = ListExtensions.<PassiveResource, JField>map(this.pcmEntity.getPassiveResource_BasicComponent(), _function);
      Iterables.<JField>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      JMethod _withImplementation = new JMethod().withName("setComponentFrame").withParameters(PcmCommons.stackframeParameterList()).withImplementation(
        "this.myComponentStackFrame = myComponentStackFrame; this.myDefaultComponentStackFrame = new de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe<Object>();");
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withImplementation)));
      JMethod _withMethodAnnotation = new JMethod().withName("setContext").withParameters("Object arg0").withImplementation(
        "// TODO Auto-generated method stub;").withMethodAnnotation("@Override");
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withMethodAnnotation)));
      final Function1<ServiceEffectSpecification, JMethod> _function = (ServiceEffectSpecification it) -> {
        JMethod _withParameters = new JMethod().withName(JavaNames.serviceName(it.getDescribedService__SEFF())).withReturnType(
          PcmCommons.stackframeType()).withParameters(PcmCommons.stackContextParameterList());
        StringConcatenation _builder = new StringConcatenation();
        String _actions = new PcmIIOPProtoAction().actions(((ResourceDemandingBehaviour) it).getSteps_Behaviour().get(0));
        _builder.append(_actions);
        _builder.newLineIfNotEmpty();
        _builder.append("return null;");
        _builder.newLine();
        return _withParameters.withImplementation(_builder.toString());
      };
      List<JMethod> _map = ListExtensions.<ServiceEffectSpecification, JMethod>map(this.pcmEntity.getServiceEffectSpecifications__BasicComponent(), _function);
      Iterables.<JMethod>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJField> jeeClassDependencyInjection() {
    LinkedList<JField> _xblockexpression = null;
    {
      final Function1<AssemblyConnector, Boolean> _function = (AssemblyConnector it) -> {
        return Boolean.valueOf(it.getRequiredRole_AssemblyConnector().getRequiringEntity_RequiredRole().equals(this.pcmEntity));
      };
      final Iterable<AssemblyConnector> basicComponentAssemblyConnectors = IterableExtensions.<AssemblyConnector>filter(this.assemblyConnectors, _function);
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      for (final AssemblyConnector assemblyConnector : basicComponentAssemblyConnectors) {
        {
          OperationProvidedRole assemblyProvidedRole = assemblyConnector.getProvidedRole_AssemblyConnector();
          JField _withName = new JField().withName(StringExtensions.toFirstLower(JavaNames.javaName(assemblyConnector.getRequiredRole_AssemblyConnector())));
          String _lowerCase = JavaNames.javaName(assemblyProvidedRole.getProvidingEntity_ProvidedRole()).toLowerCase();
          String _plus = (_lowerCase + 
            ".interfaces.ejb.");
          String _javaName = JavaNames.javaName(assemblyProvidedRole.getProvidedInterface__OperationProvidedRole());
          String _plus_1 = (_plus + _javaName);
          JField _withType = _withName.withType(_plus_1);
          Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType)));
        }
      }
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public String jeeClassStatelessAnnotation() {
    Object isStateless = Boolean.valueOf(true);
    EList<StereotypeApplication> basicComponentAppliedStereotypes = StereotypeAPI.getStereotypeApplications(this.pcmEntity, "Stateless");
    boolean _notEquals = (!Objects.equal(basicComponentAppliedStereotypes, null));
    if (_notEquals) {
      for (final StereotypeApplication appliedStatelessStereotype : basicComponentAppliedStereotypes) {
        isStateless = appliedStatelessStereotype.eGet(appliedStatelessStereotype.getExtension().getSource().getTaggedValue("isStateless"));
      }
    }
    boolean _equals = isStateless.equals(Boolean.valueOf(true));
    if (_equals) {
      return JavaConstants.JEE_EJB_ANNOTATION_STATELESS;
    } else {
      return JavaConstants.JEE_EJB_ANNOTATION_STATEFUL;
    }
  }
}
