package org.palladiosimulator.protocom.tech.pojo.repository;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.pcm.seff.ResourceDemandingBehaviour;
import org.palladiosimulator.pcm.seff.ServiceEffectSpecification;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.DataTypes;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.Parameters;
import org.palladiosimulator.protocom.tech.rmi.PojoClass;
import org.palladiosimulator.protocom.tech.rmi.util.PcmRMIStubAction;

/**
 * Defining the content of component implementations (classes implementing the component behavior).
 * 
 * @author Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoBasicComponentClass extends PojoClass<BasicComponent> {
  public PojoBasicComponentClass(final BasicComponent pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    String _interfaceName = JavaNames.interfaceName(this.pcmEntity);
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_interfaceName));
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _withParameters = new JMethod().withParameters("String assemblyContextID");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.assemblyContextID = assemblyContextID;");
    _builder.newLine();
    {
      final Function1<ProvidedRole, Boolean> _function = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, OperationProvidedRole> _function_1 = (ProvidedRole it) -> {
        return ((OperationProvidedRole) it);
      };
      Iterable<OperationProvidedRole> _map = IterableExtensions.<ProvidedRole, OperationProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function), _function_1);
      boolean _hasElements = false;
      for(final OperationProvidedRole role : _map) {
        if (!_hasElements) {
          _hasElements = true;
          _builder.append("try {");
        }
        String _portMemberVar = JavaNames.portMemberVar(role);
        _builder.append(_portMemberVar);
        _builder.append(" = new ");
        String _fqnPort = JavaNames.fqnPort(role);
        _builder.append(_fqnPort);
        _builder.append("(this, assemblyContextID);");
        _builder.newLineIfNotEmpty();
      }
      if (_hasElements) {
        _builder.append("} catch (java.rmi.RemoteException e) {  }");
      }
    }
    _builder.newLine();
    {
      final Function1<ProvidedRole, Boolean> _function_2 = (ProvidedRole it) -> {
        return Boolean.valueOf(InfrastructureProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, InfrastructureProvidedRole> _function_3 = (ProvidedRole it) -> {
        return ((InfrastructureProvidedRole) it);
      };
      Iterable<InfrastructureProvidedRole> _map_1 = IterableExtensions.<ProvidedRole, InfrastructureProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function_2), _function_3);
      boolean _hasElements_1 = false;
      for(final InfrastructureProvidedRole role_1 : _map_1) {
        if (!_hasElements_1) {
          _hasElements_1 = true;
          _builder.append("try {");
        }
        String _portMemberVar_1 = JavaNames.portMemberVar(role_1);
        _builder.append(_portMemberVar_1);
        _builder.append(" = new ");
        String _fqnPort_1 = JavaNames.fqnPort(role_1);
        _builder.append(_fqnPort_1);
        _builder.append("(this, assemblyContextID);");
        _builder.newLineIfNotEmpty();
      }
      if (_hasElements_1) {
        _builder.append("} catch (java.rmi.RemoteException e) {  }");
      }
    }
    _builder.newLine();
    {
      EList<PassiveResource> _passiveResource_BasicComponent = this.pcmEntity.getPassiveResource_BasicComponent();
      for(final PassiveResource resource : _passiveResource_BasicComponent) {
        _builder.append("passive_resource_");
        String _javaVariableName = JavaNames.javaVariableName(resource.getEntityName());
        _builder.append(_javaVariableName);
        _builder.append(" = new java.util.concurrent.Semaphore(de.uka.ipd.sdq.simucomframework.variables.StackContext.evaluateStatic(\"");
        String _specificationString = JavaNames.specificationString(resource.getCapacity_PassiveResource().getSpecification());
        _builder.append(_specificationString);
        _builder.append("\", Integer.class), true);");
        _builder.newLineIfNotEmpty();
      }
    }
    JMethod _withImplementation = _withParameters.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<JField> _xblockexpression = null;
    {
      final LinkedList<JField> results = CollectionLiterals.<JField>newLinkedList();
      JField _withType = new JField().withName("myContext").withType(JavaNames.fqnContextInterface(this.pcmEntity));
      Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType)));
      JField _withType_1 = new JField().withName("assemblyContextID").withType("String");
      Iterables.<JField>addAll(results, Collections.<JField>unmodifiableList(CollectionLiterals.<JField>newArrayList(_withType_1)));
      final Function1<ProvidedRole, Boolean> _function = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, OperationProvidedRole> _function_1 = (ProvidedRole it) -> {
        return ((OperationProvidedRole) it);
      };
      final Function1<OperationProvidedRole, JField> _function_2 = (OperationProvidedRole it) -> {
        return new JField().withName(JavaNames.portMemberVar(it)).withType(JavaNames.fqn(it.getProvidedInterface__OperationProvidedRole()));
      };
      Iterable<JField> _map = IterableExtensions.<OperationProvidedRole, JField>map(IterableExtensions.<ProvidedRole, OperationProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function), _function_1), _function_2);
      Iterables.<JField>addAll(results, _map);
      final Function1<ProvidedRole, Boolean> _function_3 = (ProvidedRole it) -> {
        return Boolean.valueOf(InfrastructureProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, InfrastructureProvidedRole> _function_4 = (ProvidedRole it) -> {
        return ((InfrastructureProvidedRole) it);
      };
      final Function1<InfrastructureProvidedRole, JField> _function_5 = (InfrastructureProvidedRole it) -> {
        return new JField().withName(JavaNames.portMemberVar(it)).withType(JavaNames.fqn(it.getProvidedInterface__InfrastructureProvidedRole()));
      };
      Iterable<JField> _map_1 = IterableExtensions.<InfrastructureProvidedRole, JField>map(IterableExtensions.<ProvidedRole, InfrastructureProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function_3), _function_4), _function_5);
      Iterables.<JField>addAll(results, _map_1);
      final Function1<PassiveResource, JField> _function_6 = (PassiveResource it) -> {
        JField _jField = new JField();
        String _javaVariableName = JavaNames.javaVariableName(it.getEntityName());
        String _plus = ("passive_resource_" + _javaVariableName);
        return _jField.withName(_plus).withType("java.util.concurrent.Semaphore");
      };
      List<JField> _map_2 = ListExtensions.<PassiveResource, JField>map(this.pcmEntity.getPassiveResource_BasicComponent(), _function_6);
      Iterables.<JField>addAll(results, _map_2);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<JMethod> _xblockexpression = null;
    {
      final LinkedList<JMethod> results = CollectionLiterals.<JMethod>newLinkedList();
      JMethod _withParameters = new JMethod().withName("setContext").withParameters("Object myContext");
      String _fqnContextInterface = JavaNames.fqnContextInterface(this.pcmEntity);
      String _plus = ("this.myContext = (" + _fqnContextInterface);
      String _plus_1 = (_plus + ") myContext;");
      JMethod _withImplementation = _withParameters.withImplementation(_plus_1);
      Iterables.<JMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withImplementation)));
      final Function1<ServiceEffectSpecification, JMethod> _function = (ServiceEffectSpecification it) -> {
        JMethod _withParameters_1 = new JMethod().withName(JavaNames.serviceNameStub(it.getDescribedService__SEFF())).withReturnType(DataTypes.getReturnDataType(it.getDescribedService__SEFF())).withParameters(Parameters.getParameterList(it.getDescribedService__SEFF()));
        StringConcatenation _builder = new StringConcatenation();
        String _actions = new PcmRMIStubAction().actions(((ResourceDemandingBehaviour) it).getSteps_Behaviour().get(0));
        _builder.append(_actions);
        _builder.newLineIfNotEmpty();
        {
          if ((((DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("byte") || 
            DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("double")) || 
            DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("int")) || 
            DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("long"))) {
            _builder.append("return 0;");
            _builder.newLine();
          } else {
            boolean _equals = DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("char");
            if (_equals) {
              _builder.append("return \'A\';");
              _builder.newLine();
            } else {
              boolean _equals_1 = DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("boolean");
              if (_equals_1) {
                _builder.append("return false;");
                _builder.newLine();
              } else {
                boolean _equals_2 = DataTypes.getReturnDataType(it.getDescribedService__SEFF()).equals("void");
                boolean _not = (!_equals_2);
                if (_not) {
                  _builder.append("return null;");
                  _builder.newLine();
                }
              }
            }
          }
        }
        return _withParameters_1.withImplementation(_builder.toString());
      };
      List<JMethod> _map = ListExtensions.<ServiceEffectSpecification, JMethod>map(this.pcmEntity.getServiceEffectSpecifications__BasicComponent(), _function);
      Iterables.<JMethod>addAll(results, _map);
      final Function1<ProvidedRole, Boolean> _function_1 = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, JMethod> _function_2 = (ProvidedRole it) -> {
        JMethod _withReturnType = new JMethod().withName(JavaNames.portGetter(it)).withReturnType(JavaNames.fqn(((OperationProvidedRole) it).getProvidedInterface__OperationProvidedRole()));
        String _portMemberVar = JavaNames.portMemberVar(((OperationProvidedRole) it));
        String _plus_2 = ("return " + _portMemberVar);
        String _plus_3 = (_plus_2 + ";");
        return _withReturnType.withImplementation(_plus_3);
      };
      Iterable<JMethod> _map_1 = IterableExtensions.<ProvidedRole, JMethod>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function_1), _function_2);
      Iterables.<JMethod>addAll(results, _map_1);
      JMethod _withStaticModifier = new JMethod().withName("main").withParameters("String[] args").withStaticModifier();
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("String ip = org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getIpFromArguments(args);");
      _builder.newLine();
      _builder.append("int port = org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getPortFromArguments(args);");
      _builder.newLine();
      _builder.newLine();
      _builder.append("String assemblyContext = org.palladiosimulator.protocom.framework.java.se.AbstractMain.getAssemblyContextFromArguments(args);");
      _builder.newLine();
      _builder.newLine();
      _builder.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.setRemoteAddress(ip);");
      _builder.newLine();
      _builder.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.setRegistryPort(port);");
      _builder.newLine();
      _builder.newLine();
      _builder.append("new ");
      String _fqn = JavaNames.fqn(this.pcmEntity);
      _builder.append(_fqn);
      _builder.append("(assemblyContext);");
      _builder.newLineIfNotEmpty();
      JMethod _withImplementation_1 = _withStaticModifier.withImplementation(_builder.toString());
      results.add(_withImplementation_1);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }
}
