package org.palladiosimulator.protocom.tech.rmi.system;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Functions.Function1;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.InfrastructureProvidedRole;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.ProvidedRole;
import org.palladiosimulator.protocom.lang.java.IJField;
import org.palladiosimulator.protocom.lang.java.IJMethod;
import org.palladiosimulator.protocom.lang.java.impl.JField;
import org.palladiosimulator.protocom.lang.java.impl.JMethod;
import org.palladiosimulator.protocom.lang.java.util.JavaConstants;
import org.palladiosimulator.protocom.lang.java.util.JavaNames;
import org.palladiosimulator.protocom.lang.java.util.PcmCommons;
import org.palladiosimulator.protocom.tech.rmi.PojoComposedStructureClass;

/**
 * @author Thomas Zolynski, Sebastian Lehrig
 */
@SuppressWarnings("all")
public class PojoSystemClass extends PojoComposedStructureClass<org.palladiosimulator.pcm.system.System> {
  public PojoSystemClass(final org.palladiosimulator.pcm.system.System pcmEntity) {
    super(pcmEntity);
  }

  @Override
  public Collection<String> interfaces() {
    String _interfaceName = JavaNames.interfaceName(this.pcmEntity);
    return Collections.<String>unmodifiableList(CollectionLiterals.<String>newArrayList(_interfaceName, JavaConstants.SERIALIZABLE_INTERFACE));
  }

  @Override
  public Collection<? extends IJMethod> constructors() {
    JMethod _withParameters = new JMethod().withParameters("String assemblyContextID");
    StringConcatenation _builder = new StringConcatenation();
    _builder.append("this.assemblyContextID = assemblyContextID;");
    _builder.newLine();
    _builder.newLine();
    _builder.append("initInnerComponents();");
    _builder.newLine();
    _builder.append("\t\t\t\t\t");
    _builder.newLine();
    {
      final Function1<ProvidedRole, Boolean> _function = (ProvidedRole it) -> {
        return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
      };
      final Function1<ProvidedRole, OperationProvidedRole> _function_1 = (ProvidedRole it) -> {
        return ((OperationProvidedRole) it);
      };
      Iterable<OperationProvidedRole> _map = IterableExtensions.<ProvidedRole, OperationProvidedRole>map(IterableExtensions.<ProvidedRole>filter(this.pcmEntity.getProvidedRoles_InterfaceProvidingEntity(), _function), _function_1);
      boolean _hasElements = false;
      for(final OperationProvidedRole role : _map) {
        if (!_hasElements) {
          _hasElements = true;
          _builder.append("try {");
        }
        String _portMemberVar = JavaNames.portMemberVar(role);
        _builder.append(_portMemberVar);
        _builder.append(" = new ");
        String _fqnPort = JavaNames.fqnPort(role);
        _builder.append(_fqnPort);
        _builder.append("(");
        _builder.newLineIfNotEmpty();
        _builder.append("(");
        String _fqn = JavaNames.fqn(role.getProvidedInterface__OperationProvidedRole());
        _builder.append(_fqn);
        _builder.append(") my");
        String _javaName = JavaNames.javaName(PcmCommons.getProvidedDelegationConnector(this.pcmEntity, role).getAssemblyContext_ProvidedDelegationConnector());
        _builder.append(_javaName);
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t\t\t\t\t\t\t\t\t");
        _builder.newLine();
        _builder.append("this, assemblyContextID);");
        _builder.newLine();
      }
      if (_hasElements) {
        _builder.append("} catch (java.rmi.RemoteException e) {  }");
      }
    }
    JMethod _withImplementation = _withParameters.withImplementation(_builder.toString());
    return Collections.<IJMethod>unmodifiableList(CollectionLiterals.<IJMethod>newArrayList(_withImplementation));
  }

  @Override
  public Collection<? extends IJField> fields() {
    LinkedList<IJField> _xblockexpression = null;
    {
      final LinkedList<IJField> results = CollectionLiterals.<IJField>newLinkedList();
      Collection<? extends IJField> _fields = super.fields();
      Iterables.<IJField>addAll(results, _fields);
      final Function1<AssemblyContext, JField> _function = (AssemblyContext it) -> {
        JField _jField = new JField();
        String _javaName = JavaNames.javaName(it);
        String _plus = ("my" + _javaName);
        JField _withName = _jField.withName(_plus);
        String _fqn = JavaNames.fqn(it.getEncapsulatedComponent__AssemblyContext());
        String _plus_1 = ("org.palladiosimulator.protocom.framework.java.se.port.IPerformancePrototypePort<" + _fqn);
        String _plus_2 = (_plus_1 + ">");
        return _withName.withType(_plus_2);
      };
      List<JField> _map = ListExtensions.<AssemblyContext, JField>map(this.pcmEntity.getAssemblyContexts__ComposedStructure(), _function);
      Iterables.<IJField>addAll(results, _map);
      _xblockexpression = results;
    }
    return _xblockexpression;
  }

  @Override
  public Collection<? extends IJMethod> methods() {
    LinkedList<IJMethod> _xblockexpression = null;
    {
      final LinkedList<IJMethod> results = CollectionLiterals.<IJMethod>newLinkedList();
      Collection<? extends IJMethod> _methods = super.methods();
      Iterables.<IJMethod>addAll(results, _methods);
      JMethod _withVisibilityModifier = new JMethod().withName("initInnerComponents").withVisibilityModifier(JavaConstants.VISIBILITY_PRIVATE);
      StringConcatenation _builder = new StringConcatenation();
      _builder.append("try {");
      _builder.newLine();
      {
        EList<AssemblyContext> _assemblyContexts__ComposedStructure = this.pcmEntity.getAssemblyContexts__ComposedStructure();
        for(final AssemblyContext assemblyContext : _assemblyContexts__ComposedStructure) {
          {
            final Function1<ProvidedRole, Boolean> _function = (ProvidedRole it) -> {
              return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
            };
            int _size = IterableExtensions.size(IterableExtensions.<ProvidedRole>filter(assemblyContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), _function));
            boolean _greaterThan = (_size > 0);
            if (_greaterThan) {
              _builder.append("\t");
              _builder.append("my");
              String _javaName = JavaNames.javaName(assemblyContext);
              _builder.append(_javaName, "\t");
              _builder.append(" = (org.palladiosimulator.protocom.framework.java.se.port.IPerformancePrototypePort<");
              String _fqn = JavaNames.fqn(assemblyContext.getEncapsulatedComponent__AssemblyContext());
              _builder.append(_fqn, "\t");
              _builder.append(">) org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.lookup(\"");
              final Function1<ProvidedRole, Boolean> _function_1 = (ProvidedRole it) -> {
                return Boolean.valueOf(OperationProvidedRole.class.isInstance(it));
              };
              ProvidedRole _get = ((ProvidedRole[])Conversions.unwrapArray(IterableExtensions.<ProvidedRole>filter(assemblyContext.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), _function_1), ProvidedRole.class))[0];
              String _portClassName = JavaNames.portClassName(((OperationProvidedRole) _get));
              _builder.append(_portClassName, "\t");
              _builder.append("_");
              String _id = assemblyContext.getId();
              _builder.append(_id, "\t");
              _builder.append("\");");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t");
      _builder.newLine();
      {
        EList<AssemblyContext> _assemblyContexts__ComposedStructure_1 = this.pcmEntity.getAssemblyContexts__ComposedStructure();
        for(final AssemblyContext assemblyContext_1 : _assemblyContexts__ComposedStructure_1) {
          {
            final Function1<ProvidedRole, Boolean> _function_2 = (ProvidedRole it) -> {
              return Boolean.valueOf(InfrastructureProvidedRole.class.isInstance(it));
            };
            int _size_1 = IterableExtensions.size(IterableExtensions.<ProvidedRole>filter(assemblyContext_1.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), _function_2));
            boolean _greaterThan_1 = (_size_1 > 0);
            if (_greaterThan_1) {
              _builder.append("\t");
              _builder.append("my");
              String _javaName_1 = JavaNames.javaName(assemblyContext_1);
              _builder.append(_javaName_1, "\t");
              _builder.append(" = (org.palladiosimulator.protocom.framework.java.se.port.IPerformancePrototypePort<");
              String _fqn_1 = JavaNames.fqn(assemblyContext_1.getEncapsulatedComponent__AssemblyContext());
              _builder.append(_fqn_1, "\t");
              _builder.append(">) org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.lookup(\"");
              final Function1<ProvidedRole, Boolean> _function_3 = (ProvidedRole it) -> {
                return Boolean.valueOf(InfrastructureProvidedRole.class.isInstance(it));
              };
              ProvidedRole _get_1 = ((ProvidedRole[])Conversions.unwrapArray(IterableExtensions.<ProvidedRole>filter(assemblyContext_1.getEncapsulatedComponent__AssemblyContext().getProvidedRoles_InterfaceProvidingEntity(), _function_3), ProvidedRole.class))[0];
              String _portClassName_1 = JavaNames.portClassName(((InfrastructureProvidedRole) _get_1));
              _builder.append(_portClassName_1, "\t");
              _builder.append("_");
              String _id_1 = assemblyContext_1.getId();
              _builder.append(_id_1, "\t");
              _builder.append("\");");
              _builder.newLineIfNotEmpty();
            }
          }
        }
      }
      _builder.append("\t");
      _builder.newLine();
      {
        EList<AssemblyContext> _assemblyContexts__ComposedStructure_2 = this.pcmEntity.getAssemblyContexts__ComposedStructure();
        for(final AssemblyContext assemblyContext_2 : _assemblyContexts__ComposedStructure_2) {
          _builder.append("\t");
          _builder.append("init");
          String _javaName_2 = JavaNames.javaName(assemblyContext_2);
          _builder.append(_javaName_2, "\t");
          _builder.append("();");
          _builder.newLineIfNotEmpty();
        }
      }
      _builder.append("\t");
      _builder.newLine();
      _builder.append("} catch (java.rmi.RemoteException e) {");
      _builder.newLine();
      _builder.append("\t");
      _builder.append("e.printStackTrace();");
      _builder.newLine();
      _builder.append("}");
      _builder.newLine();
      JMethod _withImplementation = _withVisibilityModifier.withImplementation(_builder.toString());
      Iterables.<IJMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withImplementation)));
      JMethod _withStaticModifier = new JMethod().withName("main").withParameters("String... args").withStaticModifier();
      StringConcatenation _builder_1 = new StringConcatenation();
      _builder_1.append("String ip = org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getIpFromArguments(args);");
      _builder_1.newLine();
      _builder_1.append("int port = org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.getPortFromArguments(args);");
      _builder_1.newLine();
      _builder_1.newLine();
      _builder_1.append("String assemblyContext = org.palladiosimulator.protocom.framework.java.se.AbstractMain.getAssemblyContextFromArguments(args);");
      _builder_1.newLine();
      _builder_1.newLine();
      _builder_1.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.setRemoteAddress(ip);");
      _builder_1.newLine();
      _builder_1.append("org.palladiosimulator.protocom.framework.java.se.registry.RmiRegistry.setRegistryPort(port);");
      _builder_1.newLine();
      _builder_1.newLine();
      _builder_1.append("new ");
      String _fqn_2 = JavaNames.fqn(this.pcmEntity);
      _builder_1.append(_fqn_2);
      _builder_1.append("(assemblyContext);");
      _builder_1.newLineIfNotEmpty();
      JMethod _withImplementation_1 = _withStaticModifier.withImplementation(_builder_1.toString());
      Iterables.<IJMethod>addAll(results, Collections.<JMethod>unmodifiableList(CollectionLiterals.<JMethod>newArrayList(_withImplementation_1)));
      _xblockexpression = results;
    }
    return _xblockexpression;
  }
}
