/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.qes.qualityEffectSpecification;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TransformationType implements Enumerator
{
    IS(0, "IS", "="),
    PLUS(1, "PLUS", "+"),
    MINUS(2, "MINUS", "-"),
    MULTIPLICATION(3, "MULTIPLICATION", "*"),
    DIVISION(4, "DIVISION", "/");

    public static final int IS_VALUE = 0;
    public static final int PLUS_VALUE = 1;
    public static final int MINUS_VALUE = 2;
    public static final int MULTIPLICATION_VALUE = 3;
    public static final int DIVISION_VALUE = 4;
    private static final TransformationType[] VALUES_ARRAY;
    public static final List<TransformationType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TransformationType[]{IS, PLUS, MINUS, MULTIPLICATION, DIVISION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TransformationType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransformationType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransformationType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TransformationType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TransformationType get(int value) {
        switch (value) {
            case 0: {
                return IS;
            }
            case 1: {
                return PLUS;
            }
            case 2: {
                return MINUS;
            }
            case 3: {
                return MULTIPLICATION;
            }
            case 4: {
                return DIVISION;
            }
        }
        return null;
    }

    private TransformationType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

