/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.qualitymodel.helper;

import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.EnumLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.NumericLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.SetLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contract.QMLContract.ValueLiteral;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Dimension;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.DimensionType;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.DimensionTypeEnum;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.DimensionTypeNumeric;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.DimensionTypeSet;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Element;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.EnumRelationSemantics;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.Order;
import de.uka.ipd.sdq.dsexplore.qml.contracttype.QMLContractType.RelationSemantics;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class NqrUtil {
    public static double calculateSetValue(SetLiteral setValue, ArrayList<Element> rankedElements) {
        Element[] values = (Element[])setValue.getValues().toArray();
        double result = 0.0;
        if (values.length == 0) {
            return -1.0;
        }
        Element[] elementArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            Element value = elementArray[n2];
            int j = 0;
            while (j < rankedElements.size()) {
                if (EcoreUtil.equals((EObject)((EObject)rankedElements.get(j)), (EObject)value)) {
                    result += (double)(j + 1);
                }
                ++j;
            }
            ++n2;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double getNqrValue(Dimension criterionDim, Dimension targetDim, ValueLiteral value) {
        DimensionType type = criterionDim.getType();
        RelationSemantics relSem = type.getRelationSemantics();
        ValueLiteral targetLiteral = value;
        if (type instanceof DimensionTypeSet) {
            DimensionTypeSet dts = (DimensionTypeSet)type;
            EList elems = dts.getElements();
            EList order = dts.getOrder();
            ArrayList<Element> rankedElements = NqrUtil.rankElements((List<Element>)elems, (List<Order>)order, relSem);
            if (!(targetLiteral instanceof SetLiteral)) throw new RuntimeException("Mismatch between DimensionType and ValueLiteral");
            return NqrUtil.calculateSetValue((SetLiteral)targetLiteral, rankedElements);
        }
        if (type instanceof DimensionTypeEnum) {
            DimensionTypeEnum dte = (DimensionTypeEnum)type;
            EList elems = dte.getElements();
            EList order = dte.getOrder();
            ArrayList<Element> rankedElements = NqrUtil.rankElements((List<Element>)elems, (List<Order>)order, relSem);
            if (!(targetLiteral instanceof EnumLiteral)) throw new RuntimeException("Mismatch between DimensionType and ValueLiteral");
            Element targetElement = ((EnumLiteral)targetLiteral).getValue();
            return rankedElements.indexOf(targetElement);
        }
        if (!(type instanceof DimensionTypeNumeric)) throw new RuntimeException("Wrong DimensionType!");
        if (!(targetLiteral instanceof NumericLiteral)) throw new RuntimeException("Mismatch between DimensionType and ValueLiteral");
        Double targetValue = ((NumericLiteral)targetLiteral).getValue();
        return targetValue;
    }

    public static ArrayList<Element> rankElements(List<Element> elems, List<Order> order, RelationSemantics relSem) {
        assert (order.size() > 0);
        ArrayList<Element> resultOrder = new ArrayList<Element>();
        resultOrder.add(order.get(0).getBiggerElement());
        resultOrder.add(order.get(0).getSmallerElement());
        int i = 1;
        while (i < order.size()) {
            Order ord = order.get(i);
            if (!resultOrder.contains(ord.getBiggerElement())) {
                resultOrder.add(0, ord.getBiggerElement());
            }
            if (!resultOrder.contains(ord.getSmallerElement())) {
                resultOrder.add(resultOrder.indexOf(ord.getBiggerElement()) + 1, ord.getSmallerElement());
            }
            ++i;
        }
        if (relSem.getRelSem() == EnumRelationSemantics.INCREASING) {
            Collections.reverse(resultOrder);
        }
        return resultOrder;
    }
}

