/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.edp2.launch;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.palladiosimulator.edp2.impl.RepositoryManager;
import org.palladiosimulator.edp2.models.Repository.Repository;
import org.palladiosimulator.edp2.ui.dialogs.datasource.ConfigureDatasourceDialog;

public class EDP2Tab
extends AbstractLaunchConfigurationTab {
    private Text dataField;
    protected String selectedRepositoryID;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EDP2Tab.this.setDirty(true);
                EDP2Tab.this.updateLaunchConfigurationDialog();
            }
        };
        Group dataSetGroup = new Group(container, 0);
        dataSetGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.numColumns = 3;
        dataSetGroup.setLayout((Layout)gridLayout2);
        dataSetGroup.setText("Data Set");
        Label dataSourceLabel = new Label((Composite)dataSetGroup, 0);
        dataSourceLabel.setText("Data source:");
        this.dataField = new Text((Composite)dataSetGroup, 2056);
        this.dataField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dataField.addModifyListener(modifyListener);
        Button browseButton = new Button((Composite)dataSetGroup, 0);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureDatasourceDialog dialog = new ConfigureDatasourceDialog(e.display.getActiveShell(), "Select Datasource...", true);
                if (dialog.open() == 0) {
                    Repository repository = (Repository)dialog.getResult();
                    EDP2Tab.this.selectedRepositoryID = repository.getId();
                    EDP2Tab.this.dataField.setText(repository.toString());
                } else if (RepositoryManager.getRepositoryFromUUID((String)EDP2Tab.this.selectedRepositoryID) == null) {
                    EDP2Tab.this.selectedRepositoryID = "";
                    EDP2Tab.this.dataField.setText("");
                }
            }
        });
    }

    public String getName() {
        return "EDP2";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.selectedRepositoryID = configuration.getAttribute("EDP2RepositoryID", "");
            Repository repository = RepositoryManager.getRepositoryFromUUID((String)this.selectedRepositoryID);
            if (repository == null) {
                this.dataField.setText("");
            } else {
                this.dataField.setText(repository.toString());
            }
        }
        catch (CoreException e) {
            this.selectedRepositoryID = "";
            this.dataField.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("EDP2RepositoryID", this.selectedRepositoryID);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("EDP2RepositoryID", -1);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Repository repository = RepositoryManager.getRepositoryFromUUID((String)this.selectedRepositoryID);
        if (repository == null) {
            this.setErrorMessage("Data source is missing!");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

