/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.palladiosimulator.measurementframework.MeasuringValue;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.AbstractRecorder;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.sensorframework.SensorFrameworkRecorderConfiguration;
import org.palladiosimulator.recorderframework.sensorframework.strategies.AbstractWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.ExecutionResultWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.HoldingTimeWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.OverallStateWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.PointInTimeWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.ResourceDemandWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.ResponseTimeWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.StateOfActiveResourceWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.StateOfPassiveResourceWriteDataStrategy;
import org.palladiosimulator.recorderframework.sensorframework.strategies.WaitingTimeWriteDataStrategy;

@Deprecated
public class SensorFrameworkRecorder
extends AbstractRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)SensorFrameworkRecorder.class.getName());
    private SensorFrameworkRecorderConfiguration recorderConfiguration;
    private static boolean flushed;
    private AbstractWriteDataStrategy writeDataStrategy;

    public void initialize(IRecorderConfiguration myRecorderConfiguration) {
        if (!(myRecorderConfiguration instanceof SensorFrameworkRecorderConfiguration)) {
            throw new IllegalArgumentException("Expected meta data of type " + SensorFrameworkRecorderConfiguration.class.getSimpleName() + " but was " + myRecorderConfiguration.getClass().getSimpleName());
        }
        this.recorderConfiguration = (SensorFrameworkRecorderConfiguration)myRecorderConfiguration;
        if (this.recorderConfiguration.isRemoteRun()) {
            throw new UnsupportedOperationException("Remote runs are not implemented yet");
        }
        IDAOFactory daoFactory = this.recorderConfiguration.getDaoFactory();
        Experiment experiment = this.recorderConfiguration.getExperiment();
        ExperimentRun run = this.recorderConfiguration.getExperimentRun();
        String recorderAcceptedMetric = this.recorderConfiguration.getRecorderAcceptedMetric().getId();
        if (recorderAcceptedMetric.equals(MetricDescriptionConstants.POINT_IN_TIME_METRIC.getId())) {
            this.writeDataStrategy = new PointInTimeWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.RESPONSE_TIME_METRIC.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.RESPONSE_TIME_METRIC_TUPLE.getId())) {
            this.writeDataStrategy = new ResponseTimeWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.HOLDING_TIME_METRIC.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.HOLDING_TIME_METRIC_TUPLE.getId())) {
            this.writeDataStrategy = new HoldingTimeWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.WAITING_TIME_METRIC.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.WAITING_TIME_METRIC_TUPLE.getId())) {
            this.writeDataStrategy = new WaitingTimeWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.RESOURCE_DEMAND_METRIC_TUPLE.getId())) {
            this.writeDataStrategy = new ResourceDemandWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE.getId()) || recorderAcceptedMetric.equals(MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_OVER_TIME_METRIC.getId())) {
            this.writeDataStrategy = new StateOfActiveResourceWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.OVERALL_STATE_OF_ACTIVE_RESOURCE_METRIC.getId())) {
            this.writeDataStrategy = new OverallStateWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.EXECUTION_RESULT_METRIC.getId())) {
            this.writeDataStrategy = new ExecutionResultWriteDataStrategy(daoFactory, experiment, run);
        } else if (recorderAcceptedMetric.equals(MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC_TUPLE.getId())) {
            this.writeDataStrategy = new StateOfPassiveResourceWriteDataStrategy(daoFactory, experiment, run);
        } else {
            throw new RuntimeException("Unsupported metric (\"" + this.recorderConfiguration.getRecorderAcceptedMetric().getName() + "\") requested to SensorFramework recorder");
        }
        this.writeDataStrategy.initialise((IRecorderConfiguration)this.recorderConfiguration);
        flushed = false;
    }

    public void writeData(MeasuringValue data) {
        if (!flushed) {
            this.writeDataStrategy.writeData((IMeasureProvider)data);
        } else if (LOGGER.isEnabledFor((Priority)Level.WARN)) {
            LOGGER.warn((Object)"Tried to write data, but the pipe has been flushed already");
        }
    }

    public synchronized void flush() {
        if (!flushed) {
            flushed = true;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)"Flushing SensorFramework data store");
            }
            this.recorderConfiguration.getDaoFactory().store();
        }
    }
}

