/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import org.palladiosimulator.commons.datastructureutils.MapHelper;
import org.palladiosimulator.recorderframework.core.config.AbstractRecorderConfiguration;

public class SensorFrameworkRecorderConfiguration
extends AbstractRecorderConfiguration
implements Serializable {
    private static final long serialVersionUID = 1L;
    private boolean isRemoteRun;
    public static final String DAO_FACTORY = "daoFactory";
    public static final String EXPERIMENT = "experiment";
    public static final String RUN = "run";
    private IDAOFactory daoFactory;
    private Experiment experiment;
    private ExperimentRun run;
    public static final String PERSISTENCE_RECORDER_ID = "SensorFramework";

    public void setConfiguration(Map<String, Object> configuration) {
        super.setConfiguration(configuration);
        this.daoFactory = (IDAOFactory)MapHelper.getValue(configuration, (String)DAO_FACTORY, IDAOFactory.class);
        this.experiment = (Experiment)MapHelper.getValue(configuration, (String)EXPERIMENT, Experiment.class);
        this.run = (ExperimentRun)MapHelper.getValue(configuration, (String)RUN, ExperimentRun.class);
    }

    public final IDAOFactory getDaoFactory() {
        return this.daoFactory;
    }

    public final Experiment getExperiment() {
        return this.experiment;
    }

    public final ExperimentRun getExperimentRun() {
        return this.run;
    }

    public boolean isRemoteRun() {
        return this.isRemoteRun;
    }

    public Map<Integer, String> getExecutionResultTypes() {
        return Collections.EMPTY_MAP;
    }
}

