/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.commons.datastructureutils.MapHelper;
import org.palladiosimulator.recorderframework.core.config.AbstractRecorderConfigurationFactory;
import org.palladiosimulator.recorderframework.sensorframework.DatasourceConfigurationInvalidException;
import org.palladiosimulator.recorderframework.sensorframework.SensorFrameworkRecorderConfiguration;

public class SensorFrameworkRecorderConfigurationFactory
extends AbstractRecorderConfigurationFactory {
    public static final String DATASOURCE_ID = "datasourceID";
    private long datasourceID;
    private IDAOFactory daoFactory;
    private Experiment experiment;
    private ExperimentRun run;

    public void initialize(Map<String, Object> configuration) {
        super.initialize(configuration);
        this.datasourceID = ((Integer)MapHelper.getValue(configuration, (String)DATASOURCE_ID, Integer.class)).intValue();
        this.initialiseNewSensorframework();
    }

    public SensorFrameworkRecorderConfiguration createRecorderConfiguration(Map<String, Object> configuration) {
        SensorFrameworkRecorderConfiguration result = new SensorFrameworkRecorderConfiguration();
        HashMap<String, Object> newConfiguration = new HashMap<String, Object>();
        newConfiguration.putAll(configuration);
        newConfiguration.put("daoFactory", this.daoFactory);
        newConfiguration.put("experiment", this.experiment);
        newConfiguration.put("run", this.run);
        result.setConfiguration(newConfiguration);
        return result;
    }

    public long getDatasourceID() {
        return this.datasourceID;
    }

    private void initialiseNewSensorframework() {
        this.daoFactory = SensorFrameworkDataset.singleton().getDataSourceByID(this.getDatasourceID());
        if (this.daoFactory == null) {
            throw new DatasourceConfigurationInvalidException();
        }
        this.experiment = this.daoFactory.createExperimentDAO().findByExperimentName(this.getExperimentName()).size() == 1 ? (Experiment)this.daoFactory.createExperimentDAO().findByExperimentName(this.getExperimentName()).iterator().next() : this.daoFactory.createExperimentDAO().addExperiment(this.getExperimentName());
        for (ExperimentRun r : this.experiment.getExperimentRuns()) {
            if (!r.getExperimentDateTime().equals(this.getExperimentRunName())) continue;
            this.run = r;
        }
        if (this.run == null) {
            this.run = this.experiment.addExperimentRun(this.getExperimentRunName());
        }
    }

    public void finalizeRecorderConfigurationFactory() {
        this.daoFactory.finalizeAndClose();
    }
}

