/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework.launch;

import de.uka.ipd.sdq.sensorframework.SensorFrameworkDataset;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.ConfigureDatasourceDialog;
import de.uka.ipd.sdq.sensorframework.dialogs.dataset.DatasourceListLabelProvider;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class SensorFrameworkTab
extends AbstractLaunchConfigurationTab {
    private Text dataField;
    protected int selectedDataSourceID;

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.setControl((Control)container);
        ModifyListener modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SensorFrameworkTab.this.setDirty(true);
                SensorFrameworkTab.this.updateLaunchConfigurationDialog();
            }
        };
        Group dataSetGroup = new Group(container, 0);
        dataSetGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        GridLayout gridLayout_2 = new GridLayout();
        gridLayout_2.numColumns = 3;
        dataSetGroup.setLayout((Layout)gridLayout_2);
        dataSetGroup.setText("Data Set");
        Label dataSourceLabel = new Label((Composite)dataSetGroup, 0);
        dataSourceLabel.setText("Data source:");
        this.dataField = new Text((Composite)dataSetGroup, 2056);
        this.dataField.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.dataField.addModifyListener(modifyListener);
        Button browseButton = new Button((Composite)dataSetGroup, 0);
        browseButton.setText("Browse...");
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConfigureDatasourceDialog dialog = new ConfigureDatasourceDialog(e.display.getActiveShell(), "Select Datasource...", true);
                if (dialog.open() == 0) {
                    IDAOFactory dataSet = (IDAOFactory)dialog.getResult();
                    SensorFrameworkTab.this.selectedDataSourceID = (int)dataSet.getID();
                    SensorFrameworkTab.this.dataField.setText(String.valueOf(dataSet.getName()) + " [" + dataSet.getID() + " ]");
                }
            }
        });
    }

    public String getName() {
        return "SensorFramework";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            this.selectedDataSourceID = configuration.getAttribute("datasourceID", -1);
            if (SensorFrameworkDataset.singleton().getDataSourceByID((long)this.selectedDataSourceID) == null) {
                this.dataField.setText("");
            } else {
                IDAOFactory factory = SensorFrameworkDataset.singleton().getDataSourceByID((long)this.selectedDataSourceID);
                this.dataField.setText(DatasourceListLabelProvider.dataSetRepresentation((IDAOFactory)factory));
            }
        }
        catch (CoreException e) {
            this.selectedDataSourceID = -1;
            this.dataField.setText("");
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("datasourceID", this.selectedDataSourceID);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute("datasourceID", -1);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        if (SensorFrameworkDataset.singleton().getDataSourceByID((long)this.selectedDataSourceID) == null) {
            this.setErrorMessage("Data source is missing!");
            return false;
        }
        return true;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

