/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.recorderframework.sensorframework.strategies;

import de.uka.ipd.sdq.sensorframework.entities.Experiment;
import de.uka.ipd.sdq.sensorframework.entities.ExperimentRun;
import de.uka.ipd.sdq.sensorframework.entities.State;
import de.uka.ipd.sdq.sensorframework.entities.StateSensor;
import de.uka.ipd.sdq.sensorframework.entities.dao.IDAOFactory;
import javax.measure.Measure;
import javax.measure.quantity.Dimensionless;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.measurementframework.measureprovider.IMeasureProvider;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.recorderframework.core.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.sensorframework.SensorFrameworkRecorderConfiguration;
import org.palladiosimulator.recorderframework.sensorframework.SensorHelper;
import org.palladiosimulator.recorderframework.sensorframework.strategies.AbstractWriteDataStrategy;

public class OverallStateWriteDataStrategy
extends AbstractWriteDataStrategy {
    private State idleState;
    private State busyState;

    public OverallStateWriteDataStrategy(IDAOFactory daoFactory, Experiment experiment, ExperimentRun run) {
        super(daoFactory, experiment, run);
    }

    @Override
    public void initialise(IRecorderConfiguration recorderConfiguration) {
        SensorFrameworkRecorderConfiguration sensorFrameworkRecorderConfig = (SensorFrameworkRecorderConfiguration)recorderConfiguration;
        String sensorId = sensorFrameworkRecorderConfig.getRecorderAcceptedMetric().getTextualDescription();
        this.idleState = SensorHelper.createOrReuseState(this.daoFactory, "Idle");
        this.busyState = SensorHelper.createOrReuseState(this.daoFactory, "Busy");
        this.sensor = SensorHelper.createOrReuseStateSensor(this.daoFactory, this.experiment, sensorId, this.idleState);
        if (!((StateSensor)this.sensor).getSensorStates().contains(this.idleState)) {
            ((StateSensor)this.sensor).addSensorState(this.idleState);
        }
        ((StateSensor)this.sensor).addSensorState(this.busyState);
    }

    @Override
    public void writeData(IMeasureProvider data) {
        Measure measurementTimeMeasure = data.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        Measure numericStateMeasure = data.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC);
        double measurementTime = measurementTimeMeasure.doubleValue((Unit)SI.SECOND);
        int numericState = numericStateMeasure.intValue(Dimensionless.UNIT);
        State state = null;
        state = numericState == 0 ? this.idleState : this.busyState;
        this.run.addStateMeasurement((StateSensor)this.sensor, state, measurementTime);
    }
}

