/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.markov;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StateType implements Enumerator
{
    DEFAULT(0, "Default", "Default"),
    START(1, "Start", "Start"),
    SUCCESS(2, "Success", "Success"),
    FAILURE(3, "Failure", "Failure");

    public static final int DEFAULT_VALUE = 0;
    public static final int START_VALUE = 1;
    public static final int SUCCESS_VALUE = 2;
    public static final int FAILURE_VALUE = 3;
    private static final StateType[] VALUES_ARRAY;
    public static final List<StateType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new StateType[]{DEFAULT, START, SUCCESS, FAILURE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static StateType get(String literal) {
        StateType[] stateTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            StateType result = stateTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static StateType getByName(String name) {
        StateType[] stateTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            StateType result = stateTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static StateType get(int value) {
        switch (value) {
            case 0: {
                return DEFAULT;
            }
            case 1: {
                return START;
            }
            case 2: {
                return SUCCESS;
            }
            case 3: {
                return FAILURE;
            }
        }
        return null;
    }

    private StateType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

