/**
 * <copyright>
 * </copyright>
 *
 * $Id$
 */
package org.palladiosimulator.reliability.sensitivity.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers. The
 * adapters generated by this factory convert EMF adapter notifications into calls to
 * {@link #fireNotifyChanged fireNotifyChanged}. The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances. <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class SensitivityItemProviderAdapterFactory
        extends org.palladiosimulator.reliability.sensitivity.util.SensitivityAdapterFactory
        implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

    /**
     * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComposedAdapterFactory parentAdapterFactory;

    /**
     * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected IChangeNotifier changeNotifier = new ChangeNotifier();

    /**
     * This keeps track of all the supported types checked by {@link #isFactoryForType
     * isFactoryForType}. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected Collection<Object> supportedTypes = new ArrayList<Object>();

    /**
     * This constructs an instance. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    public SensitivityItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.SensitivityConfiguration} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected SensitivityConfigurationItemProvider sensitivityConfigurationItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.SensitivityConfiguration}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createSensitivityConfigurationAdapter() {
        if (this.sensitivityConfigurationItemProvider == null) {
            this.sensitivityConfigurationItemProvider = new SensitivityConfigurationItemProvider(this);
        }

        return this.sensitivityConfigurationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.CombinedSensitivityParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CombinedSensitivityParameterItemProvider combinedSensitivityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.CombinedSensitivityParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCombinedSensitivityParameterAdapter() {
        if (this.combinedSensitivityParameterItemProvider == null) {
            this.combinedSensitivityParameterItemProvider = new CombinedSensitivityParameterItemProvider(this);
        }

        return this.combinedSensitivityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.ComponentReliabilityParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ComponentReliabilityParameterItemProvider componentReliabilityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.ComponentReliabilityParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createComponentReliabilityParameterAdapter() {
        if (this.componentReliabilityParameterItemProvider == null) {
            this.componentReliabilityParameterItemProvider = new ComponentReliabilityParameterItemProvider(this);
        }

        return this.componentReliabilityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.StringParameterSequence} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected StringParameterSequenceItemProvider stringParameterSequenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.StringParameterSequence}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createStringParameterSequenceAdapter() {
        if (this.stringParameterSequenceItemProvider == null) {
            this.stringParameterSequenceItemProvider = new StringParameterSequenceItemProvider(this);
        }

        return this.stringParameterSequenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.DoubleParameterRange} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DoubleParameterRangeItemProvider doubleParameterRangeItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.DoubleParameterRange}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDoubleParameterRangeAdapter() {
        if (this.doubleParameterRangeItemProvider == null) {
            this.doubleParameterRangeItemProvider = new DoubleParameterRangeItemProvider(this);
        }

        return this.doubleParameterRangeItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.DoubleParameterSequence} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DoubleParameterSequenceItemProvider doubleParameterSequenceItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.DoubleParameterSequence}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createDoubleParameterSequenceAdapter() {
        if (this.doubleParameterSequenceItemProvider == null) {
            this.doubleParameterSequenceItemProvider = new DoubleParameterSequenceItemProvider(this);
        }

        return this.doubleParameterSequenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.InternalActionReliabilityParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected InternalActionReliabilityParameterItemProvider internalActionReliabilityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.InternalActionReliabilityParameter}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createInternalActionReliabilityParameterAdapter() {
        if (this.internalActionReliabilityParameterItemProvider == null) {
            this.internalActionReliabilityParameterItemProvider = new InternalActionReliabilityParameterItemProvider(
                    this);
        }

        return this.internalActionReliabilityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.ProbabilisticBranchParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected ProbabilisticBranchParameterItemProvider probabilisticBranchParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.ProbabilisticBranchParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createProbabilisticBranchParameterAdapter() {
        if (this.probabilisticBranchParameterItemProvider == null) {
            this.probabilisticBranchParameterItemProvider = new ProbabilisticBranchParameterItemProvider(this);
        }

        return this.probabilisticBranchParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.HardwareMTTFParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected HardwareMTTFParameterItemProvider hardwareMTTFParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.HardwareMTTFParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createHardwareMTTFParameterAdapter() {
        if (this.hardwareMTTFParameterItemProvider == null) {
            this.hardwareMTTFParameterItemProvider = new HardwareMTTFParameterItemProvider(this);
        }

        return this.hardwareMTTFParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.HardwareMTTRParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected HardwareMTTRParameterItemProvider hardwareMTTRParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.HardwareMTTRParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createHardwareMTTRParameterAdapter() {
        if (this.hardwareMTTRParameterItemProvider == null) {
            this.hardwareMTTRParameterItemProvider = new HardwareMTTRParameterItemProvider(this);
        }

        return this.hardwareMTTRParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.ResourceMTTFParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ResourceMTTFParameterItemProvider resourceMTTFParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.ResourceMTTFParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceMTTFParameterAdapter() {
        if (this.resourceMTTFParameterItemProvider == null) {
            this.resourceMTTFParameterItemProvider = new ResourceMTTFParameterItemProvider(this);
        }

        return this.resourceMTTFParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.ResourceMTTRParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected ResourceMTTRParameterItemProvider resourceMTTRParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.ResourceMTTRParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createResourceMTTRParameterAdapter() {
        if (this.resourceMTTRParameterItemProvider == null) {
            this.resourceMTTRParameterItemProvider = new ResourceMTTRParameterItemProvider(this);
        }

        return this.resourceMTTRParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.NetworkReliabilityParameter} instances.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected NetworkReliabilityParameterItemProvider networkReliabilityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.NetworkReliabilityParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createNetworkReliabilityParameterAdapter() {
        if (this.networkReliabilityParameterItemProvider == null) {
            this.networkReliabilityParameterItemProvider = new NetworkReliabilityParameterItemProvider(this);
        }

        return this.networkReliabilityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.CommunicationLinkReliabilityParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected CommunicationLinkReliabilityParameterItemProvider communicationLinkReliabilityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.CommunicationLinkReliabilityParameter}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createCommunicationLinkReliabilityParameterAdapter() {
        if (this.communicationLinkReliabilityParameterItemProvider == null) {
            this.communicationLinkReliabilityParameterItemProvider = new CommunicationLinkReliabilityParameterItemProvider(
                    this);
        }

        return this.communicationLinkReliabilityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.SoftwareReliabilityParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SoftwareReliabilityParameterItemProvider softwareReliabilityParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.SoftwareReliabilityParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createSoftwareReliabilityParameterAdapter() {
        if (this.softwareReliabilityParameterItemProvider == null) {
            this.softwareReliabilityParameterItemProvider = new SoftwareReliabilityParameterItemProvider(this);
        }

        return this.softwareReliabilityParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.VariableUsageParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected VariableUsageParameterItemProvider variableUsageParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.VariableUsageParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createVariableUsageParameterAdapter() {
        if (this.variableUsageParameterItemProvider == null) {
            this.variableUsageParameterItemProvider = new VariableUsageParameterItemProvider(this);
        }

        return this.variableUsageParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.UsageBranchParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected UsageBranchParameterItemProvider usageBranchParameterItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.UsageBranchParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createUsageBranchParameterAdapter() {
        if (this.usageBranchParameterItemProvider == null) {
            this.usageBranchParameterItemProvider = new UsageBranchParameterItemProvider(this);
        }

        return this.usageBranchParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.DoubleOffsetSequence} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    protected DoubleOffsetSequenceItemProvider doubleOffsetSequenceItemProvider;

    /**
     * This creates an adapter for a {@link org.palladiosimulator.reliability.sensitivity.DoubleOffsetSequence}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter createDoubleOffsetSequenceAdapter() {
        if (this.doubleOffsetSequenceItemProvider == null) {
            this.doubleOffsetSequenceItemProvider = new DoubleOffsetSequenceItemProvider(this);
        }

        return this.doubleOffsetSequenceItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.SoftwareFailureTypesParameter} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected SoftwareFailureTypesParameterItemProvider softwareFailureTypesParameterItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.SoftwareFailureTypesParameter}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createSoftwareFailureTypesParameterAdapter() {
        if (this.softwareFailureTypesParameterItemProvider == null) {
            this.softwareFailureTypesParameterItemProvider = new SoftwareFailureTypesParameterItemProvider(this);
        }

        return this.softwareFailureTypesParameterItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.FailureTypeResultSpecification} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FailureTypeResultSpecificationItemProvider failureTypeResultSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.FailureTypeResultSpecification}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createFailureTypeResultSpecificationAdapter() {
        if (this.failureTypeResultSpecificationItemProvider == null) {
            this.failureTypeResultSpecificationItemProvider = new FailureTypeResultSpecificationItemProvider(this);
        }

        return this.failureTypeResultSpecificationItemProvider;
    }

    /**
     * This keeps track of the one adapter used for all
     * {@link org.palladiosimulator.reliability.sensitivity.FailureDimensionResultSpecification} instances. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    protected FailureDimensionResultSpecificationItemProvider failureDimensionResultSpecificationItemProvider;

    /**
     * This creates an adapter for a
     * {@link org.palladiosimulator.reliability.sensitivity.FailureDimensionResultSpecification}.
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Adapter createFailureDimensionResultSpecificationAdapter() {
        if (this.failureDimensionResultSpecificationItemProvider == null) {
            this.failureDimensionResultSpecificationItemProvider = new FailureDimensionResultSpecificationItemProvider(
                    this);
        }

        return this.failureDimensionResultSpecificationItemProvider;
    }

    /**
     * This returns the root adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    /**
     * This sets the composed adapter factory that contains this factory. <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void setParentAdapterFactory(final ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public boolean isFactoryForType(final Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    /**
     * This implementation substitutes the factory itself as the key for the adapter. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public Adapter adapt(final Notifier notifier, final Object type) {
        return super.adapt(notifier, this);
    }

    /**
     * <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public Object adapt(final Object object, final Object type) {
        if (this.isFactoryForType(type)) {
            final Object adapter = super.adapt(object, type);
            if (!(type instanceof Class<?>) || (((Class<?>) type).isInstance(adapter))) {
                return adapter;
            }
        }

        return null;
    }

    /**
     * This adds a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void addListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    /**
     * This removes a listener. <!-- begin-user-doc --> <!-- end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void removeListener(final INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    /**
     * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
     * begin-user-doc --> <!-- end-user-doc -->
     *
     * @generated
     */
    @Override
    public void fireNotifyChanged(final Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);

        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    /**
     * This disposes all of the item providers created by this factory. <!-- begin-user-doc --> <!--
     * end-user-doc -->
     * 
     * @generated
     */
    @Override
    public void dispose() {
        if (this.sensitivityConfigurationItemProvider != null) {
            this.sensitivityConfigurationItemProvider.dispose();
        }
        if (this.combinedSensitivityParameterItemProvider != null) {
            this.combinedSensitivityParameterItemProvider.dispose();
        }
        if (this.componentReliabilityParameterItemProvider != null) {
            this.componentReliabilityParameterItemProvider.dispose();
        }
        if (this.stringParameterSequenceItemProvider != null) {
            this.stringParameterSequenceItemProvider.dispose();
        }
        if (this.doubleParameterRangeItemProvider != null) {
            this.doubleParameterRangeItemProvider.dispose();
        }
        if (this.doubleParameterSequenceItemProvider != null) {
            this.doubleParameterSequenceItemProvider.dispose();
        }
        if (this.internalActionReliabilityParameterItemProvider != null) {
            this.internalActionReliabilityParameterItemProvider.dispose();
        }
        if (this.probabilisticBranchParameterItemProvider != null) {
            this.probabilisticBranchParameterItemProvider.dispose();
        }
        if (this.hardwareMTTFParameterItemProvider != null) {
            this.hardwareMTTFParameterItemProvider.dispose();
        }
        if (this.hardwareMTTRParameterItemProvider != null) {
            this.hardwareMTTRParameterItemProvider.dispose();
        }
        if (this.resourceMTTFParameterItemProvider != null) {
            this.resourceMTTFParameterItemProvider.dispose();
        }
        if (this.resourceMTTRParameterItemProvider != null) {
            this.resourceMTTRParameterItemProvider.dispose();
        }
        if (this.networkReliabilityParameterItemProvider != null) {
            this.networkReliabilityParameterItemProvider.dispose();
        }
        if (this.communicationLinkReliabilityParameterItemProvider != null) {
            this.communicationLinkReliabilityParameterItemProvider.dispose();
        }
        if (this.softwareReliabilityParameterItemProvider != null) {
            this.softwareReliabilityParameterItemProvider.dispose();
        }
        if (this.variableUsageParameterItemProvider != null) {
            this.variableUsageParameterItemProvider.dispose();
        }
        if (this.usageBranchParameterItemProvider != null) {
            this.usageBranchParameterItemProvider.dispose();
        }
        if (this.doubleOffsetSequenceItemProvider != null) {
            this.doubleOffsetSequenceItemProvider.dispose();
        }
        if (this.softwareFailureTypesParameterItemProvider != null) {
            this.softwareFailureTypesParameterItemProvider.dispose();
        }
        if (this.failureTypeResultSpecificationItemProvider != null) {
            this.failureTypeResultSpecificationItemProvider.dispose();
        }
        if (this.failureDimensionResultSpecificationItemProvider != null) {
            this.failureDimensionResultSpecificationItemProvider.dispose();
        }
    }

}
