/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.sensitivity;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum DoubleOffsetType implements Enumerator
{
    ADD(0, "ADD", "ADD"),
    SUBTRACT(1, "SUBTRACT", "SUBTRACT"),
    MULTIPLY(2, "MULTIPLY", "MULTIPLY"),
    DIVIDE(3, "DIVIDE", "DIVIDE");

    public static final int ADD_VALUE = 0;
    public static final int SUBTRACT_VALUE = 1;
    public static final int MULTIPLY_VALUE = 2;
    public static final int DIVIDE_VALUE = 3;
    private static final DoubleOffsetType[] VALUES_ARRAY;
    public static final List<DoubleOffsetType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new DoubleOffsetType[]{ADD, SUBTRACT, MULTIPLY, DIVIDE};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static DoubleOffsetType get(String literal) {
        DoubleOffsetType[] doubleOffsetTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleOffsetType result = doubleOffsetTypeArray[n2];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static DoubleOffsetType getByName(String name) {
        DoubleOffsetType[] doubleOffsetTypeArray = VALUES_ARRAY;
        int n = VALUES_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            DoubleOffsetType result = doubleOffsetTypeArray[n2];
            if (result.getName().equals(name)) {
                return result;
            }
            ++n2;
        }
        return null;
    }

    public static DoubleOffsetType get(int value) {
        switch (value) {
            case 0: {
                return ADD;
            }
            case 1: {
                return SUBTRACT;
            }
            case 2: {
                return MULTIPLY;
            }
            case 3: {
                return DIVIDE;
            }
        }
        return null;
    }

    private DoubleOffsetType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

