/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.helper;

import java.io.OutputStream;
import org.apache.log4j.Appender;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.WriterAppender;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class LoggingHelper {
    private static LoggingHelper singletonInstance = null;

    public static LoggingHelper getSingletonInstance() {
        if (singletonInstance == null) {
            singletonInstance = new LoggingHelper();
        }
        return singletonInstance;
    }

    private LoggingHelper() {
    }

    private MessageConsole createOrReferenceMessageConsole() {
        IConsole console;
        String SimuServiceConsoleName = "PCM Reliability Solver: Markov Comparison";
        IConsole[] iConsoleArray = ConsolePlugin.getDefault().getConsoleManager().getConsoles();
        int n = iConsoleArray.length;
        int n2 = 0;
        while (n2 < n) {
            console = iConsoleArray[n2];
            if (console.getName().equals(SimuServiceConsoleName)) {
                return (MessageConsole)console;
            }
            ++n2;
        }
        console = new MessageConsole(SimuServiceConsoleName, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        return console;
    }

    public void initializeLogging() {
        MessageConsole console = this.createOrReferenceMessageConsole();
        console.activate();
        console.clearConsole();
        MessageConsoleStream stream = console.newMessageStream();
        PatternLayout myLayout = new PatternLayout("[%-10t] %-5p: %m%n");
        WriterAppender writerAppender = new WriterAppender((Layout)myLayout, (OutputStream)stream);
        BasicConfigurator.resetConfiguration();
        BasicConfigurator.configure((Appender)writerAppender);
        Logger.getRootLogger().setLevel(Level.INFO);
    }
}

