/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.seff.ProbabilisticBranchTransition;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class ProbabilisticBranchSensitivity
extends MarkovSensitivity {
    private double baseValue;
    private ProbabilisticBranchTransition transition = null;
    private String transitionId;

    public ProbabilisticBranchSensitivity(String name, String branchTransitionId, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
        this.transitionId = branchTransitionId;
    }

    @Override
    protected boolean alterModel() {
        if (this.transition == null) {
            return false;
        }
        this.transition.setBranchProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValue));
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        List repositories = this.getModel().getRepositories();
        if (repositories.size() == 0) {
            LOGGER.error((Object)"No PCM Repositories found.");
            return;
        }
        for (Repository repository : repositories) {
            EList branchTransitions = this.helper.getElements((EObject)repository, SeffFactory.eINSTANCE.createProbabilisticBranchTransition().eClass());
            for (EObject object : branchTransitions) {
                if (!((ProbabilisticBranchTransition)object).getId().equals(this.transitionId)) continue;
                this.transition = (ProbabilisticBranchTransition)object;
                this.baseValue = ((ProbabilisticBranchTransition)object).getBranchProbability();
                return;
            }
        }
        if (this.transition == null) {
            LOGGER.error((Object)("Did not find any ProbabilisticBranchTransition with ID \"" + this.transitionId + "\""));
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Branch Transition Name");
        headings.add("Branch Transition ID");
        headings.add("Branch Probability");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.transition.getEntityName());
        resultList.add(this.transitionId);
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

