/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.pcm.reliability.InternalFailureOccurrenceDescription;
import org.palladiosimulator.pcm.repository.Repository;
import org.palladiosimulator.pcm.seff.InternalAction;
import org.palladiosimulator.pcm.seff.SeffFactory;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.solver.sensitivity.MarkovSensitivity;

public class SoftwareSensitivity
extends MarkovSensitivity {
    private List<Double> baseValues = null;
    private List<InternalFailureOccurrenceDescription> descriptions = null;

    public SoftwareSensitivity(String name, DoubleParameterVariation variation) {
        super(name, (SensitivityParameterVariation)variation);
    }

    @Override
    protected boolean alterModel() {
        int i = 0;
        while (i < this.descriptions.size()) {
            this.descriptions.get(i).setFailureProbability(this.calculator.calculateCurrentDoubleValue(this.getDoubleVariation(), this.getCurrentStepNumber(), this.baseValues.get(i)));
            ++i;
        }
        return true;
    }

    @Override
    protected void extractSensitivityInformation() {
        this.descriptions = new BasicEList();
        this.baseValues = new ArrayList<Double>();
        List repositories = this.getModel().getRepositories();
        if (repositories.size() == 0) {
            LOGGER.error((Object)"No PCM Repositories found.");
            return;
        }
        for (Repository repository : repositories) {
            EList internalActions = this.helper.getElements((EObject)repository, SeffFactory.eINSTANCE.createInternalAction().eClass());
            for (EObject object : internalActions) {
                for (InternalFailureOccurrenceDescription description : ((InternalAction)object).getInternalFailureOccurrenceDescriptions__InternalAction()) {
                    this.descriptions.add(description);
                    this.baseValues.add(description.getFailureProbability());
                }
            }
        }
        if (this.descriptions.size() == 0) {
            LOGGER.error((Object)"Did not find any FailureOccurrenceDescriptions in the PCM Repository.");
        }
    }

    @Override
    protected List<List<String>> getLogHeadingsMulti() {
        ArrayList<List<String>> resultList = new ArrayList<List<String>>();
        ArrayList<String> headings = new ArrayList<String>();
        headings.add("Software Failure Probabilities");
        resultList.add(headings);
        return resultList;
    }

    @Override
    protected List<String> getLogSingleResultsMulti() {
        ArrayList<String> resultList = new ArrayList<String>();
        resultList.add(this.calculator.getCurrentLogEntry((SensitivityParameterVariation)this.getDoubleVariation(), this.getCurrentStepNumber()));
        return resultList;
    }
}

