/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.compare;

import java.io.File;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.reliability.helper.EMFHelper;
import org.palladiosimulator.reliability.markov.Label;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.State;
import org.palladiosimulator.reliability.markov.Transition;

public class MarkovComparator {
    private static final Logger LOGGER = Logger.getLogger((String)MarkovComparator.class.getName());
    private long changeCount = 0L;
    private int deletedStateCount = 0;
    private int deletedTransitionCount = 0;
    private String firstName = "";
    private int newStateCount = 0;
    private int newTransitionCount = 0;
    private String secondName = "";
    private long stateChangeCount = 0L;
    private int statePropertyChangeCount = 0;
    private long transitionChangeCount = 0L;
    private int transitionPropertyChangeCount = 0;

    public void compare(MarkovChain firstChain, MarkovChain secondChain) {
        LOGGER.info((Object)"Start Markov compare");
        if (this.firstName == "") {
            this.firstName = firstChain.getName();
        }
        if (this.secondName == "") {
            this.secondName = secondChain.getName();
        }
        this.compareProperties(firstChain, secondChain);
        this.compareStates((EList<State>)firstChain.getStates(), (EList<State>)secondChain.getStates());
        this.compareTransitions((EList<Transition>)firstChain.getTransitions(), (EList<Transition>)secondChain.getTransitions());
        this.printCompareStatistics(firstChain, secondChain);
        LOGGER.info((Object)"End Markov compare");
    }

    public void compare(String firstMarkovFileName, String secondMarkovFileName) {
        this.firstName = new File(firstMarkovFileName).getName();
        this.secondName = new File(secondMarkovFileName).getName();
        EObject ch1 = EMFHelper.loadFromXMIFile((String)firstMarkovFileName);
        EObject ch2 = EMFHelper.loadFromXMIFile((String)secondMarkovFileName);
        if (ch1 == null || !(ch1 instanceof MarkovChain) || ch2 == null || !(ch2 instanceof MarkovChain)) {
            return;
        }
        this.compare((MarkovChain)ch1, (MarkovChain)ch2);
    }

    private void compareProperties(MarkovChain ch1, MarkovChain ch2) {
        if (!ch1.getName().equals(ch2.getName())) {
            LOGGER.debug((Object)("Chain name changed from \"" + ch1.getName() + "\" to \"" + ch2.getName() + "\""));
        }
    }

    private void compareProperties(State st1, State st2) {
        boolean typeEquals = st1.getType().equals((Object)st2.getType());
        boolean nameEquals = st1.getName().equals(st2.getName());
        boolean labelsEqual = this.testEquality((EList<Label>)st1.getLabels(), (EList<Label>)st2.getLabels());
        if (!(typeEquals && nameEquals && labelsEqual)) {
            LOGGER.debug((Object)("State \"" + st1.getName() + "\" changed:"));
            this.increaseStatePropertyChangeCount();
            if (!nameEquals) {
                LOGGER.debug((Object)("- mame changed from \"" + st1.getName() + "\" to \"" + st2.getName() + "\""));
            }
            if (!typeEquals) {
                LOGGER.debug((Object)("- type changed from \"" + st1.getType().toString() + "\" to \"" + st2.getType().toString() + "\""));
            }
            if (!labelsEqual) {
                LOGGER.debug((Object)"- labels changed");
            }
        }
    }

    private void compareProperties(Transition tr1, Transition tr2) {
        boolean probabilityEquals;
        boolean nameEquals = tr1.getName().equals(tr2.getName());
        boolean bl = probabilityEquals = tr1.getProbability() == tr2.getProbability();
        if (!nameEquals || !probabilityEquals) {
            LOGGER.debug((Object)("Transition \"" + tr1.getName() + "\" changed:"));
            this.increaseTransitionPropertyChangeCount();
            if (!nameEquals) {
                LOGGER.debug((Object)("- mame changed from \"" + tr1.getName() + "\" to \"" + tr2.getName() + "\""));
            }
            if (!probabilityEquals) {
                LOGGER.debug((Object)("- probability changed from " + tr1.getProbability() + " to " + tr2.getProbability()));
            }
        }
    }

    private void compareStates(EList<State> states1, EList<State> states2) {
        ArrayList<State> statesCopy1 = new ArrayList<State>();
        statesCopy1.addAll((Collection<State>)states1);
        ArrayList<State> statesCopy2 = new ArrayList<State>();
        statesCopy2.addAll((Collection<State>)states2);
        while (statesCopy1.size() > 0) {
            State st1 = (State)statesCopy1.get(0);
            State st2 = null;
            for (State st2_candidate : statesCopy2) {
                if (!this.testIdentity(st1, st2_candidate)) continue;
                st2 = st2_candidate;
                break;
            }
            if (st2 != null) {
                this.compareProperties(st1, st2);
                statesCopy1.remove(st1);
                statesCopy2.remove(st2);
                continue;
            }
            LOGGER.debug((Object)("State \"" + st1.getName() + "\" deleted"));
            this.increaseDeletedStateCount();
            statesCopy1.remove(st1);
        }
        while (statesCopy2.size() > 0) {
            State st2 = (State)statesCopy2.get(0);
            LOGGER.debug((Object)("State \"" + st2.getName() + "\" added"));
            this.increaseNewStateCount();
            statesCopy2.remove(st2);
        }
    }

    private void compareTransitions(EList<Transition> transitions1, EList<Transition> transitions2) {
        ArrayList<Transition> transitionsCopy1 = new ArrayList<Transition>();
        transitionsCopy1.addAll((Collection<Transition>)transitions1);
        ArrayList<Transition> transitionsCopy2 = new ArrayList<Transition>();
        transitionsCopy2.addAll((Collection<Transition>)transitions2);
        while (transitionsCopy1.size() > 0) {
            Transition tr1 = (Transition)transitionsCopy1.get(0);
            Transition tr2 = null;
            for (Transition tr2_candidate : transitionsCopy2) {
                if (!this.testIdentity(tr1, tr2_candidate)) continue;
                tr2 = tr2_candidate;
                break;
            }
            if (tr2 != null) {
                this.compareProperties(tr1, tr2);
                transitionsCopy1.remove(tr1);
                transitionsCopy2.remove(tr2);
                continue;
            }
            LOGGER.debug((Object)("Transition \"" + tr1.getName() + "\" deleted"));
            this.increaseDeletedTransitionCount();
            transitionsCopy1.remove(tr1);
        }
        while (transitionsCopy2.size() > 0) {
            Transition tr2 = (Transition)transitionsCopy2.get(0);
            LOGGER.debug((Object)("Transition \"" + tr2.getName() + "\" added"));
            this.increaseNewTransitionCount();
            transitionsCopy2.remove(tr2);
        }
    }

    private DecimalFormat getDecimalFormat(ArrayList<Integer> numbers) {
        int maxPlaces = 0;
        for (Integer number : numbers) {
            int places = number.toString().length();
            if (places <= maxPlaces) continue;
            maxPlaces = places;
        }
        String formatString = "";
        int i = 0;
        while (i < maxPlaces) {
            formatString = String.valueOf(formatString) + "0";
            ++i;
        }
        return new DecimalFormat(formatString);
    }

    private void increaseDeletedStateCount() {
        ++this.changeCount;
        ++this.stateChangeCount;
        ++this.deletedStateCount;
    }

    private void increaseDeletedTransitionCount() {
        ++this.changeCount;
        ++this.transitionChangeCount;
        ++this.deletedTransitionCount;
    }

    private void increaseNewStateCount() {
        ++this.changeCount;
        ++this.stateChangeCount;
        ++this.newStateCount;
    }

    private void increaseNewTransitionCount() {
        ++this.changeCount;
        ++this.transitionChangeCount;
        ++this.newTransitionCount;
    }

    private void increaseStatePropertyChangeCount() {
        ++this.changeCount;
        ++this.stateChangeCount;
        ++this.statePropertyChangeCount;
    }

    private void increaseTransitionPropertyChangeCount() {
        ++this.changeCount;
        ++this.transitionChangeCount;
        ++this.transitionPropertyChangeCount;
    }

    private void printCompareStatistics(MarkovChain firstChain, MarkovChain secondChain) {
        int numberOfStates1 = firstChain.getStates().size();
        int numberOfStates2 = secondChain.getStates().size();
        int numberOfTransitions1 = firstChain.getTransitions().size();
        int numberOfTransitions2 = secondChain.getTransitions().size();
        int numberOfChangedStates1 = this.statePropertyChangeCount;
        int numberOfDeletedStates1 = this.deletedStateCount;
        int numberOfUnchangedStates1 = numberOfStates1 - numberOfChangedStates1 - numberOfDeletedStates1;
        int numberOfChangedStates2 = this.statePropertyChangeCount;
        int numberOfAddedStates2 = this.newStateCount;
        int numberOfUnchangedStates2 = numberOfStates2 - numberOfChangedStates2 - numberOfAddedStates2;
        int numberOfChangedTransitions1 = this.transitionPropertyChangeCount;
        int numberOfDeletedTransitions1 = this.deletedTransitionCount;
        int numberOfUnchangedTransitions1 = numberOfTransitions1 - numberOfChangedTransitions1 - numberOfDeletedTransitions1;
        int numberOfChangedTransitions2 = this.transitionPropertyChangeCount;
        int numberOfAddedTransitions2 = this.newTransitionCount;
        int numberOfUnchangedTransitions2 = numberOfTransitions2 - numberOfChangedTransitions2 - numberOfAddedTransitions2;
        double percentageOfChangedStates1 = 100.0 * ((double)numberOfChangedStates1 / (double)numberOfStates1);
        double percentageOfDeletedStates1 = 100.0 * ((double)numberOfDeletedStates1 / (double)numberOfStates1);
        double percentageOfUnchangedStates1 = 100.0 * ((double)numberOfUnchangedStates1 / (double)numberOfStates1);
        double percentageOfChangedTransitions1 = 100.0 * ((double)numberOfChangedTransitions1 / (double)numberOfTransitions1);
        double percentageOfDeletedTransitions1 = 100.0 * ((double)numberOfDeletedTransitions1 / (double)numberOfTransitions1);
        double percentageOfUnchangedTransitions1 = 100.0 * ((double)numberOfUnchangedTransitions1 / (double)numberOfTransitions1);
        double percentageOfChangedStates2 = 100.0 * ((double)numberOfChangedStates2 / (double)numberOfStates2);
        double percentageOfAddedStates2 = 100.0 * ((double)numberOfAddedStates2 / (double)numberOfStates2);
        double percentageOfUnchangedStates2 = 100.0 * ((double)numberOfUnchangedStates2 / (double)numberOfStates2);
        double percentageOfChangedTransitions2 = 100.0 * ((double)numberOfChangedTransitions2 / (double)numberOfTransitions2);
        double percentageOfAddedTransitions2 = 100.0 * ((double)numberOfAddedTransitions2 / (double)numberOfTransitions2);
        double percentageOfUnchangedTransitions2 = 100.0 * ((double)numberOfUnchangedTransitions2 / (double)numberOfTransitions2);
        ArrayList<Integer> numbers = new ArrayList<Integer>();
        numbers.add(numberOfStates1);
        numbers.add(numberOfStates2);
        numbers.add(numberOfTransitions1);
        numbers.add(numberOfTransitions2);
        DecimalFormat df1 = this.getDecimalFormat(numbers);
        DecimalFormat df2 = new DecimalFormat("00.00");
        LOGGER.info((Object)("States chain 1 [" + this.firstName + "]:"));
        LOGGER.info((Object)("- total:     " + df1.format(numberOfStates1)));
        LOGGER.info((Object)("- changed:   " + df1.format(numberOfChangedStates1) + " (" + df2.format(percentageOfChangedStates1) + "%)"));
        LOGGER.info((Object)("- deleted:   " + df1.format(numberOfDeletedStates1) + " (" + df2.format(percentageOfDeletedStates1) + "%)"));
        LOGGER.info((Object)("- unchanged: " + df1.format(numberOfUnchangedStates1) + " (" + df2.format(percentageOfUnchangedStates1) + "%)"));
        LOGGER.info((Object)("Transitions chain 1 [" + this.firstName + "]:"));
        LOGGER.info((Object)("- total:     " + df1.format(numberOfTransitions1)));
        LOGGER.info((Object)("- changed:   " + df1.format(numberOfChangedTransitions1) + " (" + df2.format(percentageOfChangedTransitions1) + "%)"));
        LOGGER.info((Object)("- deleted:   " + df1.format(numberOfDeletedTransitions1) + " (" + df2.format(percentageOfDeletedTransitions1) + "%)"));
        LOGGER.info((Object)("- unchanged: " + df1.format(numberOfUnchangedTransitions1) + " (" + df2.format(percentageOfUnchangedTransitions1) + "%)"));
        LOGGER.info((Object)("States chain 2 [" + this.secondName + "]:"));
        LOGGER.info((Object)("- total:     " + df1.format(numberOfStates2)));
        LOGGER.info((Object)("- changed:   " + df1.format(numberOfChangedStates2) + " (" + df2.format(percentageOfChangedStates2) + "%)"));
        LOGGER.info((Object)("- added:     " + df1.format(numberOfAddedStates2) + " (" + df2.format(percentageOfAddedStates2) + "%)"));
        LOGGER.info((Object)("- unchanged: " + df1.format(numberOfUnchangedStates2) + " (" + df2.format(percentageOfUnchangedStates2) + "%)"));
        LOGGER.info((Object)("Transitions chain 2 [" + this.secondName + "]:"));
        LOGGER.info((Object)("- total:     " + df1.format(numberOfTransitions2)));
        LOGGER.info((Object)("- changed:   " + df1.format(numberOfChangedTransitions2) + " (" + df2.format(percentageOfChangedTransitions2) + "%)"));
        LOGGER.info((Object)("- added:     " + df1.format(numberOfAddedTransitions2) + " (" + df2.format(percentageOfAddedTransitions2) + "%)"));
        LOGGER.info((Object)("- unchanged: " + df1.format(numberOfUnchangedTransitions2) + " (" + df2.format(percentageOfUnchangedTransitions2) + "%)"));
    }

    private Label searchLabelsForKey(EList<Label> labels, String key) {
        for (Label label : labels) {
            if (!label.getKey().equals(key)) continue;
            return label;
        }
        return null;
    }

    private boolean testEquality(EList<Label> labels1, EList<Label> labels2) {
        if (labels1.size() != labels2.size()) {
            return false;
        }
        int i = 0;
        while (i < labels1.size()) {
            Label label1 = (Label)labels1.get(i);
            Label label1_2 = this.searchLabelsForKey(labels2, label1.getKey());
            Label label2 = (Label)labels2.get(i);
            Label label2_1 = this.searchLabelsForKey(labels1, label2.getKey());
            if (label1_2 == null || label2_1 == null) {
                return false;
            }
            if (!label1.getValue().equals(label1_2.getValue()) || !label2.getValue().equals(label2_1.getValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean testIdentity(State st1, State st2) {
        if (st1.getTraces().size() != st2.getTraces().size()) {
            return false;
        }
        int i = 0;
        while (i < st1.getTraces().size()) {
            if (!((String)st1.getTraces().get(i)).equals(st2.getTraces().get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean testIdentity(Transition t1, Transition t2) {
        return this.testIdentity(t1.getFromState(), t2.getFromState()) && this.testIdentity(t1.getToState(), t2.getToState());
    }
}

