/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.pcm2markov;

import de.uka.ipd.sdq.probfunction.Sample;
import de.uka.ipd.sdq.probfunction.math.ManagedPMF;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.palladiosimulator.pcm.seff.AbstractAction;
import org.palladiosimulator.pcm.seff.ForkedBehaviour;
import org.palladiosimulator.reliability.markov.Label;
import org.palladiosimulator.reliability.markov.MarkovChain;
import org.palladiosimulator.reliability.markov.MarkovFactory;
import org.palladiosimulator.reliability.markov.State;
import org.palladiosimulator.reliability.markov.StateType;
import org.palladiosimulator.reliability.markov.Transition;
import org.palladiosimulator.reliability.solver.pcm2markov.FailureDescription;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovException;

public class MarkovBuilder {
    private static final String FAILURETYPEID = "FailureTypeId";
    private static final String FAILURETYPENAME = "FailureTypeName";
    private final MarkovFactory markovFactory = MarkovFactory.eINSTANCE;
    private final boolean recordTraces;

    public MarkovBuilder(boolean recordTraces) {
        this.recordTraces = recordTraces;
    }

    private State addState(MarkovChain chain, StateType type, String stateName, List<String> prefixes) {
        State state = this.markovFactory.createState();
        state.setType(type);
        state.setName(this.getStateName(stateName, prefixes));
        state.getTraces().addAll(this.getStateTraces(stateName, prefixes));
        chain.getStates().add((Object)state);
        return state;
    }

    private State addStateForFailureDescription(MarkovChain chain, List<String> prefixes, FailureDescription description) {
        State failureState = this.addState(chain, StateType.FAILURE, String.valueOf(StateType.FAILURE.toString()) + "(" + description.getFailureType().getName() + ")", prefixes);
        Label failureIdLabel = this.markovFactory.createLabel();
        failureIdLabel.setKey(FAILURETYPEID);
        failureIdLabel.setValue(description.getFailureType().getId());
        failureState.getLabels().add((Object)failureIdLabel);
        Label failureNameLabel = this.markovFactory.createLabel();
        failureNameLabel.setKey(FAILURETYPENAME);
        failureNameLabel.setValue(description.getFailureType().getName());
        failureState.getLabels().add((Object)failureNameLabel);
        return failureState;
    }

    private void appendFailureHandlingChain(MarkovChain aggregateChain, MarkovChain handlingChain, State failureState, boolean optimize) {
        this.validateChain(aggregateChain);
        this.validateChain(handlingChain);
        MarkovChain handlingChainCopy = this.copyMarkovChain(handlingChain);
        State aggregateChainSuccessState = this.getSuccessState(aggregateChain);
        List<State> aggregateChainFailureStates = this.getFailureStates(aggregateChain);
        State handlingChainStartState = this.getStartState(handlingChainCopy);
        State handlingChainSuccessState = this.getSuccessState(handlingChainCopy);
        aggregateChain.getStates().addAll((Collection)handlingChainCopy.getStates());
        aggregateChain.getTransitions().addAll((Collection)handlingChainCopy.getTransitions());
        this.delegateIncommingTransitions(aggregateChain, failureState, handlingChainStartState);
        handlingChainStartState.setType(StateType.DEFAULT);
        aggregateChain.getStates().remove((Object)failureState);
        aggregateChainFailureStates.remove(failureState);
        this.connectStates(aggregateChain, handlingChainSuccessState, aggregateChainSuccessState, 1.0);
        handlingChainSuccessState.setType(StateType.DEFAULT);
        if (optimize) {
            this.reduceState(aggregateChain, handlingChainStartState);
            this.reduceState(aggregateChain, handlingChainSuccessState);
        }
    }

    private void appendFailureHandlingMarkovChain(MarkovChain aggregateChain, List<State> aggregateFailureStates, MarkovChain handlingChain, List<String> handledFailureTypeIds, boolean optimize) {
        for (State failureState : aggregateFailureStates) {
            String failureTypeLabelValue = this.getFailureTypeId(failureState);
            if (!this.isFailureTypeHandled(handledFailureTypeIds, failureTypeLabelValue)) continue;
            this.appendFailureHandlingChain(aggregateChain, handlingChain, failureState, optimize);
        }
    }

    public void appendFailureHandlingMarkovChain(MarkovChain aggregateChain, MarkovChain handlingChain, List<String> handledFailureTypeIds, boolean optimize) {
        this.appendFailureHandlingMarkovChain(aggregateChain, this.getFailureStates(aggregateChain), handlingChain, handledFailureTypeIds, optimize);
        this.removeDuplicateFailureStates(aggregateChain, optimize);
    }

    public void appendFailureHandlingMarkovChains(MarkovChain aggregateChain, List<MarkovChain> handlingChains, List<List<String>> handledFailureTypeIdLists, boolean optimize) {
        List<State> aggregateFailureStates = this.getFailureStates(aggregateChain);
        int i = 0;
        while (i < handlingChains.size()) {
            aggregateFailureStates = this.findStates(aggregateFailureStates, StateType.FAILURE);
            this.appendFailureHandlingMarkovChain(aggregateChain, aggregateFailureStates, handlingChains.get(i), handledFailureTypeIdLists.get(i), optimize);
            ++i;
        }
        this.removeDuplicateFailureStates(aggregateChain, optimize);
    }

    private void connectStates(MarkovChain chain, State from, State to, double probability) {
        Transition transition = this.markovFactory.createTransition();
        transition.setFromState(from);
        transition.setToState(to);
        transition.setProbability(probability);
        this.nameTransition(transition);
        chain.getTransitions().add((Object)transition);
    }

    private void contributeTransition(MarkovChain markovChain, Transition transitionToContribute) {
        Transition transitionCorresponding = null;
        int i = 0;
        while (i < markovChain.getTransitions().size()) {
            if (((Transition)markovChain.getTransitions().get(i)).getFromState() == transitionToContribute.getFromState() && ((Transition)markovChain.getTransitions().get(i)).getToState() == transitionToContribute.getToState()) {
                transitionCorresponding = (Transition)markovChain.getTransitions().get(i);
                break;
            }
            ++i;
        }
        if (transitionCorresponding != null) {
            transitionCorresponding.setProbability(transitionCorresponding.getProbability() + transitionToContribute.getProbability());
        } else {
            markovChain.getTransitions().add((Object)transitionToContribute);
        }
    }

    public MarkovChain copyMarkovChain(MarkovChain originalMarkovChain) {
        MarkovChain newMarkovChain = this.markovFactory.createMarkovChain();
        newMarkovChain.setName(originalMarkovChain.getName());
        int i = 0;
        while (i < originalMarkovChain.getStates().size()) {
            State originalState = (State)originalMarkovChain.getStates().get(i);
            State newState = this.markovFactory.createState();
            newState.setName(originalState.getName());
            newState.setType(originalState.getType());
            for (Label originalLabel : originalState.getLabels()) {
                Label newLabel = this.markovFactory.createLabel();
                newLabel.setKey(originalLabel.getKey());
                newLabel.setValue(originalLabel.getValue());
                newState.getLabels().add((Object)newLabel);
            }
            newState.getTraces().addAll((Collection)originalState.getTraces());
            newMarkovChain.getStates().add((Object)newState);
            ++i;
        }
        i = 0;
        while (i < originalMarkovChain.getTransitions().size()) {
            Transition newTransition = this.markovFactory.createTransition();
            newTransition.setName(((Transition)originalMarkovChain.getTransitions().get(i)).getName());
            newTransition.setProbability(((Transition)originalMarkovChain.getTransitions().get(i)).getProbability());
            State fromState = (State)newMarkovChain.getStates().get(originalMarkovChain.getStates().indexOf((Object)((Transition)originalMarkovChain.getTransitions().get(i)).getFromState()));
            State toState = (State)newMarkovChain.getStates().get(originalMarkovChain.getStates().indexOf((Object)((Transition)originalMarkovChain.getTransitions().get(i)).getToState()));
            newTransition.setFromState(fromState);
            newTransition.setToState(toState);
            newMarkovChain.getTransitions().add((Object)newTransition);
            ++i;
        }
        return newMarkovChain;
    }

    private void delegateIncommingTransitions(MarkovChain chain, State originalState, State newState) {
        ArrayList<Transition> transitions = this.findTransitionsToState(chain, originalState);
        for (Transition transition : transitions) {
            transition.setToState(newState);
        }
    }

    private void delegateOutgoingTransitions(MarkovChain chain, State originalState, State newState) {
        ArrayList<Transition> transitions = this.findTransitionsFromState(chain, originalState);
        for (Transition transition : transitions) {
            transition.setFromState(newState);
        }
    }

    private void deleteTransitions(MarkovChain markovChain, ArrayList<Transition> transitionsToDelete) {
        int i = 0;
        while (i < transitionsToDelete.size()) {
            markovChain.getTransitions().remove((Object)transitionsToDelete.get(i));
            ++i;
        }
    }

    private State findFailureState(List<State> states, String failureTypeLabelValue) {
        for (State state : states) {
            if (!state.getType().equals((Object)StateType.FAILURE)) continue;
            for (Label label : state.getLabels()) {
                if (!label.getKey().equals(FAILURETYPEID) || !label.getValue().equals(failureTypeLabelValue)) continue;
                return state;
            }
        }
        return null;
    }

    private List<State> findFailureStates(List<State> states, String failureTypeLabelValue) {
        ArrayList<State> resultList = new ArrayList<State>();
        for (State state : states) {
            if (!state.getType().equals((Object)StateType.FAILURE)) continue;
            for (Label label : state.getLabels()) {
                if (!label.getKey().equals(FAILURETYPEID) || !label.getValue().equals(failureTypeLabelValue)) continue;
                resultList.add(state);
            }
        }
        return resultList;
    }

    private State findMatchingFailureState(List<State> states, State failureState) {
        String failureTypeLabelValue = this.getFailureTypeId(failureState);
        return this.findFailureState(states, failureTypeLabelValue);
    }

    private List<State> findMatchingFailureStates(List<State> states, State failureState) {
        String failureTypeLabelValue = this.getFailureTypeId(failureState);
        return this.findFailureStates(states, failureTypeLabelValue);
    }

    private List<State> findStates(List<State> states, StateType type) {
        ArrayList<State> resultList = new ArrayList<State>();
        for (State state : states) {
            if (!state.getType().equals((Object)type)) continue;
            resultList.add(state);
        }
        return resultList;
    }

    private ArrayList<Transition> findTransitionsFromState(MarkovChain markovChain, State sourceState) {
        ArrayList<Transition> resultList = new ArrayList<Transition>();
        int i = 0;
        while (i < markovChain.getTransitions().size()) {
            if (((Transition)markovChain.getTransitions().get(i)).getFromState() == sourceState) {
                resultList.add((Transition)markovChain.getTransitions().get(i));
            }
            ++i;
        }
        return resultList;
    }

    private ArrayList<Transition> findTransitionsToState(MarkovChain markovChain, State targetState) {
        ArrayList<Transition> resultList = new ArrayList<Transition>();
        int i = 0;
        while (i < markovChain.getTransitions().size()) {
            if (((Transition)markovChain.getTransitions().get(i)).getToState() == targetState) {
                resultList.add((Transition)markovChain.getTransitions().get(i));
            }
            ++i;
        }
        return resultList;
    }

    public List<State> getFailureStates(MarkovChain markovChain) {
        ArrayList<State> failureStates = new ArrayList<State>();
        int i = 0;
        while (i < markovChain.getStates().size()) {
            if (((State)markovChain.getStates().get(i)).getType().equals((Object)StateType.FAILURE)) {
                failureStates.add((State)markovChain.getStates().get(i));
            }
            ++i;
        }
        return failureStates;
    }

    public String getFailureTypeId(State state) {
        for (Label label : state.getLabels()) {
            if (!label.getKey().equals(FAILURETYPEID)) continue;
            return label.getValue();
        }
        return null;
    }

    public String getFailureTypeName(State state) {
        for (Label label : state.getLabels()) {
            if (!label.getKey().equals(FAILURETYPENAME)) continue;
            return label.getValue();
        }
        return null;
    }

    private String getName(List<String> prefixes) {
        String result = "";
        int i = 0;
        while (i < prefixes.size()) {
            result = String.valueOf(result) + prefixes.get(i);
            if (i < prefixes.size() - 1) {
                result = String.valueOf(result) + "::";
            }
            ++i;
        }
        return result;
    }

    public State getStartState(MarkovChain markovChain) {
        int i = 0;
        while (i < markovChain.getStates().size()) {
            if (((State)markovChain.getStates().get(i)).getType().equals((Object)StateType.START)) {
                return (State)markovChain.getStates().get(i);
            }
            ++i;
        }
        throw new MarkovException("Markov Chain has no start state.");
    }

    private String getStateName(String stateName, List<String> prefixes) {
        if (prefixes.isEmpty()) {
            return stateName;
        }
        return String.valueOf(prefixes.get(prefixes.size() - 1)) + "::" + stateName;
    }

    private List<String> getStateTraces(String stateName, List<String> prefixes) {
        ArrayList<String> resultList = new ArrayList<String>();
        if (this.recordTraces) {
            resultList.addAll(prefixes);
            resultList.add(stateName);
        }
        return resultList;
    }

    public State getSuccessState(MarkovChain markovChain) {
        int i = 0;
        while (i < markovChain.getStates().size()) {
            if (((State)markovChain.getStates().get(i)).getType().equals((Object)StateType.SUCCESS)) {
                return (State)markovChain.getStates().get(i);
            }
            ++i;
        }
        throw new MarkovException("Markov Chain has no success state.");
    }

    public void incorporateMarkovChain(MarkovChain parentChain, MarkovChain specificMarkovChain, State aggregateState, boolean optimize, boolean appendPrefixes) {
        if (!parentChain.getStates().contains((Object)aggregateState)) {
            throw new MarkovException("State '" + aggregateState + "' is not contained in the markov chain '" + parentChain.getName() + "'.");
        }
        if (!aggregateState.getType().equals((Object)StateType.DEFAULT)) {
            throw new MarkovException("Only default states can be incorporated. '" + aggregateState.getName() + "' is of type '" + aggregateState.getType() + "'.");
        }
        MarkovChain copiedSpecificMarkovChain = this.copyMarkovChain(specificMarkovChain);
        List<State> stateAggregateFailures = this.getFailureStates(parentChain);
        State stateSpecificStart = this.getStartState(copiedSpecificMarkovChain);
        State stateSpecificSuccess = this.getSuccessState(copiedSpecificMarkovChain);
        List<State> stateSpecificFailures = this.getFailureStates(copiedSpecificMarkovChain);
        if (this.recordTraces && appendPrefixes) {
            for (State specificState : copiedSpecificMarkovChain.getStates()) {
                specificState.getTraces().addAll(0, (Collection)aggregateState.getTraces());
                specificState.setName(this.getStateName((String)specificState.getTraces().get(specificState.getTraces().size() - 1), specificState.getTraces().subList(0, specificState.getTraces().size() - 1)));
            }
        }
        parentChain.getStates().addAll((Collection)copiedSpecificMarkovChain.getStates());
        parentChain.getTransitions().addAll((Collection)copiedSpecificMarkovChain.getTransitions());
        this.delegateIncommingTransitions(parentChain, aggregateState, stateSpecificStart);
        stateSpecificStart.setType(StateType.DEFAULT);
        ArrayList<State> duplicateFailureStates = new ArrayList<State>();
        for (State failureState : stateSpecificFailures) {
            State existingFailureState = this.findMatchingFailureState(stateAggregateFailures, failureState);
            if (existingFailureState == null) continue;
            this.connectStates(parentChain, failureState, existingFailureState, 1.0);
            failureState.setType(StateType.DEFAULT);
            duplicateFailureStates.add(failureState);
        }
        this.delegateOutgoingTransitions(parentChain, aggregateState, stateSpecificSuccess);
        stateSpecificSuccess.setType(StateType.DEFAULT);
        parentChain.getStates().remove((Object)aggregateState);
        if (optimize) {
            this.reduceState(parentChain, stateSpecificStart);
            this.reduceState(parentChain, stateSpecificSuccess);
            for (State failureState : duplicateFailureStates) {
                this.reduceState(parentChain, failureState);
            }
        }
    }

    public int indexOf(MarkovChain markovChain, State state) {
        int i = 0;
        while (i < markovChain.getStates().size()) {
            if (markovChain.getStates().get(i) == state) {
                return i;
            }
            ++i;
        }
        throw new MarkovException("State not found in Markov chain.");
    }

    public MarkovChain initBasicMarkovChain(List<String> prefixes) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        State successSate = this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        this.connectStates(markovChain, startState, successSate, 1.0);
        return markovChain;
    }

    public MarkovChain initBasicMarkovChainWithFailures(List<String> prefixes, List<FailureDescription> failureDescriptions) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        State successState = this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        double successProbability = 1.0;
        for (FailureDescription description : failureDescriptions) {
            State failureState = this.addStateForFailureDescription(markovChain, prefixes, description);
            this.connectStates(markovChain, startState, failureState, description.getFailureProbability());
            successProbability -= description.getFailureProbability();
        }
        if (successProbability < 0.0) {
            throw new MarkovException("Total failure probability of basic Chain \"" + this.getName(prefixes) + "\" is greater than 1.0.");
        }
        this.connectStates(markovChain, startState, successState, successProbability);
        return markovChain;
    }

    public MarkovChain initBehaviourMarkovChainByAction(List<String> prefixes, List<AbstractAction> actions, List<State> statesOut) {
        ArrayList<String> actionNames = new ArrayList<String>();
        int i = 0;
        while (i < actions.size()) {
            actionNames.add(String.valueOf(actions.get(i).getEntityName()) + "[" + actions.get(i).getId() + "]");
            ++i;
        }
        return this.initSequentialMarkovChain(prefixes, actionNames, statesOut);
    }

    public MarkovChain initBranchMarkovChain(List<String> prefixes, ArrayList<Double> branchProbabilities) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        State successState = this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        int i = 0;
        while (i < branchProbabilities.size()) {
            if (!(branchProbabilities.get(i) <= 0.0)) {
                State stateBranch = this.addState(markovChain, StateType.DEFAULT, "Alternative(" + (i + 1) + ")", prefixes);
                this.connectStates(markovChain, startState, stateBranch, branchProbabilities.get(i));
                this.connectStates(markovChain, stateBranch, successState, 1.0);
            }
            ++i;
        }
        return markovChain;
    }

    public MarkovChain initForkMarkovChain(List<String> prefixes, ArrayList<ForkedBehaviour> behaviours, ArrayList<State> statesOut) {
        ArrayList<String> behaviourNames = new ArrayList<String>();
        int i = 0;
        while (i < behaviours.size()) {
            behaviourNames.add("ForkBehaviour(" + (i + 1) + ")");
            ++i;
        }
        return this.initSequentialMarkovChain(prefixes, behaviourNames, statesOut);
    }

    public MarkovChain initLoopMarkovChain(List<String> prefixes, ManagedPMF pmf) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        State successState = this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        int i = 0;
        while (i < pmf.getModelPmf().getSamples().size()) {
            Sample sample = (Sample)pmf.getModelPmf().getSamples().get(i);
            if (!(sample.getValue() instanceof Integer)) {
                throw new MarkovException("Invalid Sample value " + sample.getValue().toString() + " in " + pmf.getModelPmf().toString());
            }
            int sampleValue = (Integer)sample.getValue();
            State stateToSuccess = startState;
            double transitionProbability = sample.getProbability();
            int j = 0;
            while (j < sampleValue) {
                State stateSample = this.addState(markovChain, StateType.DEFAULT, "Alternative(" + (i + 1) + ")-Iteration(" + (j + 1) + ")", prefixes);
                this.connectStates(markovChain, stateToSuccess, stateSample, transitionProbability);
                stateToSuccess = stateSample;
                transitionProbability = 1.0;
                ++j;
            }
            this.connectStates(markovChain, stateToSuccess, successState, transitionProbability);
            ++i;
        }
        return markovChain;
    }

    public MarkovChain initResourceFailureMarkovChain(List<String> prefixes, List<FailureDescription> failureDescriptions) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        double failureProbability = 1.0 / (double)failureDescriptions.size();
        for (FailureDescription description : failureDescriptions) {
            State failureState = this.addStateForFailureDescription(markovChain, prefixes, description);
            this.connectStates(markovChain, startState, failureState, failureProbability);
        }
        return markovChain;
    }

    public MarkovChain initSequentialMarkovChain(List<String> prefixes, List<String> stateNames, List<State> statesOut) {
        MarkovChain markovChain = this.markovFactory.createMarkovChain();
        markovChain.setName(this.getName(prefixes));
        State startState = this.addState(markovChain, StateType.START, StateType.START.toString(), prefixes);
        State successState = this.addState(markovChain, StateType.SUCCESS, StateType.SUCCESS.toString(), prefixes);
        State stateToSuccess = startState;
        int i = 0;
        while (i < stateNames.size()) {
            State state = this.addState(markovChain, StateType.DEFAULT, stateNames.get(i), prefixes);
            statesOut.add(state);
            this.connectStates(markovChain, stateToSuccess, state, 1.0);
            stateToSuccess = state;
            ++i;
        }
        this.connectStates(markovChain, stateToSuccess, successState, 1.0);
        return markovChain;
    }

    private boolean isFailureTypeHandled(List<String> handledFailureTypeIds, String occurredFailureTypeId) {
        for (String handledId : handledFailureTypeIds) {
            if (!occurredFailureTypeId.contains(handledId)) continue;
            return true;
        }
        return false;
    }

    private void nameTransition(Transition transition) {
        transition.setName(String.valueOf(transition.getFromState().getName()) + " --> " + transition.getToState().getName());
    }

    private void reduceState(MarkovChain markovChain, State stateToReduce) {
        if (!markovChain.getStates().contains((Object)stateToReduce)) {
            throw new MarkovException("Cannot reduce Markov State. The Markov Chain does not contain that state.");
        }
        if (!stateToReduce.getType().equals((Object)StateType.DEFAULT)) {
            throw new MarkovException("Cannot reduce Markov State. Only intermediate states can be reduced.");
        }
        ArrayList<Transition> transitionsToReduceState = this.findTransitionsToState(markovChain, stateToReduce);
        this.deleteTransitions(markovChain, transitionsToReduceState);
        ArrayList<Transition> transitionsFromReduceState = this.findTransitionsFromState(markovChain, stateToReduce);
        this.deleteTransitions(markovChain, transitionsFromReduceState);
        markovChain.getStates().remove((Object)stateToReduce);
        int i = 0;
        while (i < transitionsToReduceState.size()) {
            int j = 0;
            while (j < transitionsFromReduceState.size()) {
                Transition transition = this.markovFactory.createTransition();
                transition.setFromState(transitionsToReduceState.get(i).getFromState());
                transition.setToState(transitionsFromReduceState.get(j).getToState());
                transition.setProbability(transitionsToReduceState.get(i).getProbability() * transitionsFromReduceState.get(j).getProbability());
                this.nameTransition(transition);
                this.contributeTransition(markovChain, transition);
                ++j;
            }
            ++i;
        }
    }

    private void removeDuplicateFailureStates(MarkovChain markovChain, boolean optimize) {
        List<State> failureStates = this.getFailureStates(markovChain);
        ArrayList<State> duplicateFailureStates = new ArrayList<State>();
        for (State failureState : failureStates) {
            if (duplicateFailureStates.contains(failureState)) continue;
            List<State> matchingFailureStates = this.findMatchingFailureStates(failureStates, failureState);
            matchingFailureStates.remove(failureState);
            for (State matchingState : matchingFailureStates) {
                this.connectStates(markovChain, matchingState, failureState, 1.0);
                matchingState.setType(StateType.DEFAULT);
                duplicateFailureStates.add(matchingState);
            }
        }
        if (optimize) {
            for (State duplicateState : duplicateFailureStates) {
                this.reduceState(markovChain, duplicateState);
            }
        }
    }

    private void validateChain(MarkovChain chain) {
        for (Transition t : chain.getTransitions()) {
            if (t.getFromState() != null && t.getToState() != null) continue;
            throw new MarkovException("Invalid transiton in Markov Chain.");
        }
        boolean hasStart = false;
        boolean hasSuccess = false;
        for (State s : chain.getStates()) {
            if (s.getType() == StateType.START) {
                if (hasStart) {
                    throw new MarkovException("Multiple start states in Markov Chain.");
                }
                hasStart = true;
                continue;
            }
            if (s.getType() != StateType.SUCCESS) continue;
            if (hasSuccess) {
                throw new MarkovException("Multiple success states in Markov Chain.");
            }
            hasSuccess = true;
        }
        if (!hasStart) {
            throw new MarkovException("No start state in Markov Chain.");
        }
        if (!hasSuccess) {
            throw new MarkovException("No success state in Markov Chain.");
        }
    }
}

