/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.sensitivity;

import org.apache.log4j.Logger;
import org.palladiosimulator.pcm.reliability.FailureType;
import org.palladiosimulator.pcm.reliability.HardwareInducedFailureType;
import org.palladiosimulator.pcm.reliability.NetworkInducedFailureType;
import org.palladiosimulator.pcm.reliability.SoftwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.MarkovHardwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovNetworkInducedFailureType;
import org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType;
import org.palladiosimulator.reliability.sensitivity.DoubleOffsetSequence;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterRange;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterSequence;
import org.palladiosimulator.reliability.sensitivity.DoubleParameterVariation;
import org.palladiosimulator.reliability.sensitivity.FailureDimension;
import org.palladiosimulator.reliability.sensitivity.FailureDimensionResultSpecification;
import org.palladiosimulator.reliability.sensitivity.FailureTypeResultSpecification;
import org.palladiosimulator.reliability.sensitivity.SensitivityParameterVariation;
import org.palladiosimulator.reliability.sensitivity.SensitivityResultSpecification;
import org.palladiosimulator.reliability.sensitivity.StringParameterSequence;
import org.palladiosimulator.reliability.solver.pcm2markov.MarkovTransformationResult;

public class SensitivityCalculator {
    private static final Logger LOGGER = Logger.getLogger((String)SensitivityCalculator.class.getName());

    public double calculateCurrentDoubleValue(DoubleParameterVariation variation, int stepNumber, double baseValue) {
        if (variation instanceof DoubleParameterSequence) {
            DoubleParameterSequence sequence = (DoubleParameterSequence)variation;
            return (Double)sequence.getDoubleValues().get(stepNumber - 1);
        }
        if (variation instanceof DoubleOffsetSequence) {
            DoubleOffsetSequence sequence = (DoubleOffsetSequence)variation;
            switch (sequence.getDoubleOffsetType__DoubleOffsetSequence()) {
                case ADD: {
                    return baseValue + (Double)sequence.getOffsetValues().get(stepNumber - 1);
                }
                case SUBTRACT: {
                    return baseValue - (Double)sequence.getOffsetValues().get(stepNumber - 1);
                }
                case MULTIPLY: {
                    return baseValue * (Double)sequence.getOffsetValues().get(stepNumber - 1);
                }
                case DIVIDE: {
                    return baseValue / (Double)sequence.getOffsetValues().get(stepNumber - 1);
                }
            }
            LOGGER.error((Object)("Double offset type \"" + sequence.getDoubleOffsetType__DoubleOffsetSequence().getName() + "\" not yet supported."));
            return 0.0;
        }
        if (variation instanceof DoubleParameterRange) {
            DoubleParameterRange range = (DoubleParameterRange)variation;
            if (range.isConsiderStepSize()) {
                return range.getFirstValue() + range.getStepSize() * (double)(stepNumber - 1);
            }
            return range.getFirstValue() + (range.getLastValue() - range.getFirstValue()) / (double)(range.getStepCount() - 1) * (double)(stepNumber - 1);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not yet supported."));
        return 0.0;
    }

    public String calculateCurrentStringValue(StringParameterSequence sequence, int stepNumber) {
        return (String)sequence.getStringValues().get(stepNumber - 1);
    }

    private double calculateFailurePotential(MarkovTransformationResult markovResult, FailureDimensionResultSpecification specification) {
        double result = 0.0;
        for (MarkovFailureType failureType : markovResult.getCumulatedFailureTypeProbabilities().keySet()) {
            if (!this.isMatch(specification.getFailureDimension__FailureDimensionResultSpecification(), failureType)) continue;
            result += markovResult.getCumulatedFailureTypeProbabilities().get(failureType).doubleValue();
        }
        return result;
    }

    private double calculateFailurePotential(MarkovTransformationResult markovResult, FailureTypeResultSpecification specification) {
        double result = 0.0;
        block0: for (MarkovFailureType failureType : markovResult.getCumulatedFailureTypeProbabilities().keySet()) {
            for (FailureType resultType : specification.getFailureTypes__FailureTypeResultSpecification()) {
                if (!this.isMatch(failureType, resultType)) continue;
                result += markovResult.getCumulatedFailureTypeProbabilities().get(failureType).doubleValue();
                continue block0;
            }
        }
        return result;
    }

    public double calculateFailurePotential(MarkovTransformationResult result, SensitivityResultSpecification specification) {
        if (specification instanceof FailureTypeResultSpecification) {
            return this.calculateFailurePotential(result, (FailureTypeResultSpecification)specification);
        }
        if (specification instanceof FailureDimensionResultSpecification) {
            return this.calculateFailurePotential(result, (FailureDimensionResultSpecification)specification);
        }
        LOGGER.error((Object)("Result specification type \"" + specification.eClass().toString() + "\" not yet supported."));
        return 0.0;
    }

    public int calculateNumberOfSteps(SensitivityParameterVariation variation) {
        if (variation instanceof DoubleParameterRange) {
            if (((DoubleParameterRange)variation).isConsiderStepSize()) {
                DoubleParameterRange range = (DoubleParameterRange)variation;
                return (int)Math.floor(Math.abs(range.getLastValue() - range.getFirstValue()) / Math.abs(range.getStepSize())) + 1;
            }
            return ((DoubleParameterRange)variation).getStepCount();
        }
        if (variation instanceof DoubleParameterSequence) {
            return ((DoubleParameterSequence)variation).getDoubleValues().size();
        }
        if (variation instanceof DoubleOffsetSequence) {
            return ((DoubleOffsetSequence)variation).getOffsetValues().size();
        }
        if (variation instanceof StringParameterSequence) {
            return ((StringParameterSequence)variation).getStringValues().size();
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not yet supported."));
        return 0;
    }

    public String getCurrentLogEntry(SensitivityParameterVariation variation, int stepNumber) {
        if (variation instanceof DoubleOffsetSequence) {
            DoubleOffsetSequence sequence = (DoubleOffsetSequence)variation;
            switch (sequence.getDoubleOffsetType__DoubleOffsetSequence()) {
                case ADD: {
                    return "x + " + ((Double)sequence.getOffsetValues().get(stepNumber - 1)).toString();
                }
                case SUBTRACT: {
                    return "x - " + ((Double)sequence.getOffsetValues().get(stepNumber - 1)).toString();
                }
                case MULTIPLY: {
                    return "x * " + ((Double)sequence.getOffsetValues().get(stepNumber - 1)).toString();
                }
                case DIVIDE: {
                    return "x / " + ((Double)sequence.getOffsetValues().get(stepNumber - 1)).toString();
                }
            }
            LOGGER.error((Object)("Double offset type \"" + sequence.getDoubleOffsetType__DoubleOffsetSequence().getName() + "\" not yet supported."));
            return null;
        }
        if (variation instanceof DoubleParameterVariation) {
            return Double.valueOf(this.calculateCurrentDoubleValue((DoubleParameterVariation)variation, stepNumber, 0.0)).toString();
        }
        if (variation instanceof StringParameterSequence) {
            return this.calculateCurrentStringValue((StringParameterSequence)variation, stepNumber);
        }
        LOGGER.error((Object)("Parameter variation type \"" + variation.eClass().toString() + "\" not yet supported."));
        return null;
    }

    private boolean isMatch(FailureDimension dimension, MarkovFailureType type) {
        return dimension.equals((Object)FailureDimension.SOFTWARE) && type instanceof MarkovSoftwareInducedFailureType || dimension.equals((Object)FailureDimension.HARDWARE) && type instanceof MarkovHardwareInducedFailureType || dimension.equals((Object)FailureDimension.NETWORK) && type instanceof MarkovNetworkInducedFailureType;
    }

    private boolean isMatch(MarkovFailureType failureType, FailureType resultType) {
        if (failureType instanceof MarkovSoftwareInducedFailureType && resultType instanceof SoftwareInducedFailureType) {
            MarkovSoftwareInducedFailureType markovSWType = (MarkovSoftwareInducedFailureType)failureType;
            SoftwareInducedFailureType swType = (SoftwareInducedFailureType)resultType;
            return markovSWType.getSoftwareFailureId().equals(swType.getId());
        }
        if (failureType instanceof MarkovHardwareInducedFailureType && resultType instanceof HardwareInducedFailureType) {
            MarkovHardwareInducedFailureType markovHWType = (MarkovHardwareInducedFailureType)failureType;
            HardwareInducedFailureType hwType = (HardwareInducedFailureType)resultType;
            return markovHWType.getResourceTypeId().equals(hwType.getProcessingResourceType__HardwareInducedFailureType().getId());
        }
        if (failureType instanceof MarkovNetworkInducedFailureType && resultType instanceof NetworkInducedFailureType) {
            MarkovNetworkInducedFailureType markovNWType = (MarkovNetworkInducedFailureType)failureType;
            NetworkInducedFailureType nwType = (NetworkInducedFailureType)resultType;
            return markovNWType.getCommLinkResourceTypeId().equals(nwType.getCommunicationLinkResourceType__NetworkInducedFailureType().getId());
        }
        return false;
    }
}

