/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability.solver.pcm2markov;

public class MarkovResultApproximation {
    private static final int MAXACCURACY = 10;
    private int accuracy = 0;
    private double adjustedLowerBound = 0.0;
    private double adjustedUpperBound = 0.0;
    private double lowerBound = 0.0;
    private double upperBound = 0.0;

    public MarkovResultApproximation(double lowerBound, double upperBound) {
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
        this.calculateAccuracy();
        this.adjustBounds();
    }

    private void adjustBounds() {
        this.adjustedLowerBound = Math.floor(this.lowerBound * Math.pow(10.0, this.accuracy + 1)) / Math.pow(10.0, this.accuracy + 1);
        this.adjustedUpperBound = Math.ceil(this.upperBound * Math.pow(10.0, this.accuracy + 1)) / Math.pow(10.0, this.accuracy + 1);
    }

    private void calculateAccuracy() {
        double delta = this.upperBound - this.lowerBound;
        this.accuracy = 1;
        while (delta < Math.pow(0.1, this.accuracy)) {
            ++this.accuracy;
            if (this.accuracy > 10) break;
        }
        --this.accuracy;
    }

    public int getAccuracy() {
        return this.accuracy;
    }

    public double getAdjustedLowerBound() {
        return this.adjustedLowerBound;
    }

    public double getAdjustedUpperBound() {
        return this.adjustedUpperBound;
    }

    public double getLowerBound() {
        return this.lowerBound;
    }

    public double getUpperBound() {
        return this.upperBound;
    }

    public boolean hasRequiredAccuracy(int requiredAccuracy) {
        return this.accuracy >= requiredAccuracy;
    }
}

