/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability;

import org.palladiosimulator.pcm.repository.Interface;
import org.palladiosimulator.pcm.repository.Role;
import org.palladiosimulator.pcm.repository.Signature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;

public class MarkovHardwareInducedFailureType
extends MarkovFailureType {
    private static String HARDWARE_ID = "Hardware-induced failure";
    private static String HARDWARE_NAME = "Hardware-induced failure";
    private String resourceContainerId = "";
    private String resourceContainerName = "";
    private String resourceTypeId = "";
    private String resourceTypeName = "";

    public static MarkovHardwareInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, ProcessingResourceType resoureType, Signature signature, Role role, Interface iface) {
        return new MarkovHardwareInducedFailureType(evaluationType, resoureType.getId(), resoureType.getEntityName(), signature.getId(), signature.getEntityName(), role.getId(), role.getEntityName(), iface.getId(), iface.getEntityName());
    }

    public static MarkovHardwareInducedFailureType createExternalFailureType(MarkovEvaluationType evaluationType, String resourceTypeId, String signatureId, String systemRequiredRoleId) {
        return new MarkovHardwareInducedFailureType(evaluationType, resourceTypeId, "", signatureId, "", systemRequiredRoleId, "", "", "");
    }

    public static MarkovHardwareInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, ResourceContainer resourceContainer, ProcessingResourceType resourceType) {
        return new MarkovHardwareInducedFailureType(evaluationType, resourceContainer.getId(), resourceContainer.getEntityName(), resourceType.getId(), resourceType.getEntityName());
    }

    public static MarkovHardwareInducedFailureType createInternalFailureType(MarkovEvaluationType evaluationType, String resourceContainerId, String resourceTypeId) {
        return new MarkovHardwareInducedFailureType(evaluationType, resourceContainerId, "", resourceTypeId, "");
    }

    private MarkovHardwareInducedFailureType(MarkovEvaluationType evaluationType, String resourceContainerId, String resourceContainerName, String resourceTypeId, String resourceTypeName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(resourceContainerId) + "/" + resourceTypeId;
                this.name = String.valueOf(resourceContainerName) + "/" + resourceTypeName + " (system-internal hardware-induced failure)";
                break;
            }
            case TYPES: {
                this.id = resourceTypeId;
                this.name = String.valueOf(resourceTypeName) + " (hardware-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = HARDWARE_ID;
                this.name = HARDWARE_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.resourceContainerId = resourceContainerId;
        this.resourceContainerName = resourceContainerName;
        this.resourceTypeId = resourceTypeId;
        this.resourceTypeName = resourceTypeName;
        this.resourceTypeId = resourceTypeId;
        this.systemExternal = false;
    }

    private MarkovHardwareInducedFailureType(MarkovEvaluationType evaluationType, String resourceTypeId, String resourceTypeName, String signatureId, String signatureName, String systemRequiredRoleId, String systemRequiredRoleName, String interfaceId, String interfaceName) {
        switch (evaluationType) {
            case POINTSOFFAILURE: {
                this.id = String.valueOf(systemRequiredRoleId) + "/" + signatureId + "/" + resourceTypeId;
                this.name = String.valueOf(systemRequiredRoleName) + "/" + signatureName + "/" + resourceTypeName + " (system-external hardware-induced failure)";
                break;
            }
            case TYPES: {
                this.id = resourceTypeId;
                this.name = String.valueOf(resourceTypeName) + " (hardware-induced failure)";
                break;
            }
            case CLASSES: {
                this.id = HARDWARE_ID;
                this.name = HARDWARE_NAME;
                break;
            }
            default: {
                this.id = DEFAULT_ID;
                this.name = DEFAULT_NAME;
            }
        }
        this.evaluationType = evaluationType;
        this.resourceTypeId = resourceTypeId;
        this.resourceTypeName = resourceTypeName;
        this.signatureId = signatureId;
        this.signatureName = signatureName;
        this.roleId = systemRequiredRoleId;
        this.roleName = systemRequiredRoleName;
        this.interfaceId = interfaceId;
        this.interfaceName = interfaceName;
        this.systemExternal = true;
    }

    public String getResourceContainerId() {
        return this.resourceContainerId;
    }

    public String getResourceContainerName() {
        return this.resourceContainerName;
    }

    public String getResourceTypeId() {
        return this.resourceTypeId;
    }

    public String getResourceTypeName() {
        return this.resourceTypeName;
    }
}

