/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.reliability;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.apache.commons.collections15.Bag;
import org.apache.commons.collections15.bag.TreeBag;
import org.apache.log4j.Logger;
import org.palladiosimulator.commons.designpatterns.AbstractObservable;
import org.palladiosimulator.metricspec.Identifier;
import org.palladiosimulator.metricspec.util.builder.IdentifierBuilder;
import org.palladiosimulator.probeframework.probes.EventProbe;
import org.palladiosimulator.reliability.IFailureStatisticsListener;
import org.palladiosimulator.reliability.MarkovEvaluationType;
import org.palladiosimulator.reliability.MarkovFailureType;
import org.palladiosimulator.reliability.MarkovHardwareInducedFailureType;
import org.palladiosimulator.reliability.MarkovNetworkInducedFailureType;
import org.palladiosimulator.reliability.MarkovResourceTimeoutFailureType;
import org.palladiosimulator.reliability.MarkovSoftwareInducedFailureType;
import org.palladiosimulator.reliability.SoftwareFailureStatistics;
import org.palladiosimulator.reliability.probe.TakeExecutionResultProbe;

public class FailureStatistics
extends AbstractObservable<IFailureStatisticsListener> {
    private final HashSet<Long> failedRuns = new HashSet();
    private long runCount = 0L;
    private static Map<MarkovFailureType, Identifier> simFailureTypes;
    private final TakeExecutionResultProbe resultProbe;
    private final Map<FailureType, Bag<MarkovFailureType>> failureCounter = new HashMap<FailureType, Bag<MarkovFailureType>>();
    private final Identifier successIdentifier;

    public FailureStatistics() {
        FailureType[] failureTypeArray = FailureType.values();
        int n = failureTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            FailureType t = failureTypeArray[n2];
            this.failureCounter.put(t, (Bag<MarkovFailureType>)new TreeBag());
            ++n2;
        }
        this.successIdentifier = IdentifierBuilder.newIdentifierBuilder().literal("Success").build();
        if (simFailureTypes == null) {
            simFailureTypes = Collections.EMPTY_MAP;
        }
        this.resultProbe = new TakeExecutionResultProbe(this, simFailureTypes, this.successIdentifier);
    }

    public EventProbe<FailureStatistics> getExecutionResultProbe() {
        return this.resultProbe;
    }

    public void increaseUnhandledFailureCounter(MarkovFailureType failureType, Long sessionId) {
        this.increaseFailureCounter(FailureType.UNHANDLED, failureType);
        if (!this.failedRuns.contains(sessionId)) {
            this.failedRuns.add(sessionId);
        }
    }

    public Identifier getExecutionResultId(MarkovFailureType failureType) {
        if (failureType == null) {
            return this.successIdentifier;
        }
        return simFailureTypes.get(failureType);
    }

    public MarkovFailureType getExternalHardwareFailureType(String resourceTypeId, String systemRequiredRoleId, String signatureId) {
        MarkovHardwareInducedFailureType comparator = MarkovHardwareInducedFailureType.createExternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, resourceTypeId, signatureId, systemRequiredRoleId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getExternalNetworkFailureType(String commLinkResourceTypeId, String systemRequiredRoleId, String signatureId) {
        MarkovNetworkInducedFailureType comparator = MarkovNetworkInducedFailureType.createExternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, commLinkResourceTypeId, signatureId, systemRequiredRoleId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getExternalSoftwareFailureType(String softwareFailureId, String systemRequiredRoleId, String signatureId) {
        MarkovSoftwareInducedFailureType comparator = MarkovSoftwareInducedFailureType.createExternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, softwareFailureId, signatureId, systemRequiredRoleId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getFailureType(String failureTypeId) {
        for (MarkovFailureType failureType : simFailureTypes.keySet()) {
            if (!failureType.getId().equals(failureTypeId)) continue;
            return failureType;
        }
        return null;
    }

    public Identifier getFailureTypeIndex(MarkovFailureType failureType) {
        return simFailureTypes.get(failureType);
    }

    public long getFailureCount(FailureType failureType) {
        return this.getFailureCounters(failureType).size();
    }

    public Bag<MarkovFailureType> getFailureCounters(FailureType failureType) {
        return this.failureCounter.get((Object)failureType);
    }

    public MarkovFailureType getInternalHardwareFailureType(String resourceContainerId, String resourceTypeId) {
        MarkovHardwareInducedFailureType comparator = MarkovHardwareInducedFailureType.createInternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, resourceContainerId, resourceTypeId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getInternalNetworkFailureType(String linkingResourceId, String commLinkResourceTypeId) {
        MarkovNetworkInducedFailureType comparator = MarkovNetworkInducedFailureType.createInternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, linkingResourceId, commLinkResourceTypeId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getInternalSoftwareFailureType(String softwareFailureId, String internalActionId) {
        MarkovSoftwareInducedFailureType comparator = MarkovSoftwareInducedFailureType.createInternalFailureType(MarkovEvaluationType.POINTSOFFAILURE, softwareFailureId, internalActionId);
        return this.getFailureType(comparator);
    }

    public MarkovFailureType getResourceTimeoutFailureType(String assemblyContextId, String passiveResourceId) {
        MarkovResourceTimeoutFailureType comparator = MarkovResourceTimeoutFailureType.createResourceTimeoutFailureType(MarkovEvaluationType.POINTSOFFAILURE, assemblyContextId, passiveResourceId);
        return this.getFailureType(comparator);
    }

    public long getRunCount() {
        return this.runCount;
    }

    public void increaseFailureCounter(FailureType failureKind, MarkovFailureType failureType) {
        this.failureCounter.get((Object)failureKind).add((Object)failureType);
        ((IFailureStatisticsListener)this.getEventDispatcher()).executionResultRecorder(failureType);
    }

    public void recordSuccess() {
        ((IFailureStatisticsListener)this.getEventDispatcher()).executionResultRecorder(null);
    }

    public void increaseRunCount() {
        ++this.runCount;
    }

    public void printFailureStatistics(Logger logger, double simulationTime) {
        logger.warn((Object)"---- System Failure Statistics: START ----");
        logger.warn((Object)("- Total usage scenario runs:            " + this.runCount));
        logger.warn((Object)("- Total failed usage scenario runs:     " + this.failedRuns.size()));
        logger.warn((Object)("- Total simulated time units:           " + simulationTime));
        logger.warn((Object)("- Total probability of success:         " + (1.0 - (double)this.failedRuns.size() / (double)this.runCount)));
        logger.warn((Object)("- Failure rate (failures per simulated time unit): " + (double)this.failedRuns.size() / simulationTime));
        logger.warn((Object)("- Mean time between failure:            " + simulationTime / (double)this.failedRuns.size()));
        logger.warn((Object)("- Total number of faults:               " + this.getFailureCount(FailureType.TOTAL)));
        logger.warn((Object)("- Total probability of fault:           " + (double)this.getFailureCount(FailureType.TOTAL) / (double)this.runCount));
        logger.warn((Object)("- Total probability of no fault:        " + (1.0 - (double)this.getFailureCount(FailureType.TOTAL) / (double)this.runCount)));
        logger.warn((Object)("- Fault rate (recovered and non-recovered, faults per simulated time unit): " + (double)this.getFailureCount(FailureType.TOTAL) / simulationTime));
        logger.warn((Object)("- Mean time between faults (recovered and non-recovered): " + simulationTime / (double)this.getFailureCount(FailureType.TOTAL)));
        for (String failureString : this.getFailureStringsSorted(simulationTime)) {
            logger.warn((Object)failureString);
        }
        this.printHandledFailuresStatistics(logger, simulationTime);
        logger.warn((Object)"---- System Failure Statistics: END -----");
    }

    public void printRunCount(Logger logger, double simulationTime) {
        if (this.runCount % 50000L == 0L) {
            this.printFailureStatistics(logger, simulationTime);
        } else if (this.runCount % 10000L == 0L) {
            logger.warn((Object)("Current usage scenario run count: " + this.runCount));
        }
    }

    public static void setFailureTypes(List<MarkovFailureType> failureTypes) {
        simFailureTypes = new HashMap<MarkovFailureType, Identifier>();
        for (MarkovFailureType failureType : failureTypes) {
            Identifier identifier = IdentifierBuilder.newIdentifierBuilder().literal(failureType.getName()).build();
            simFailureTypes.put(failureType, identifier);
        }
    }

    private TreeSet<String> getFailureStringsSorted(double simulationTime) {
        TreeSet<String> result = new TreeSet<String>();
        for (MarkovFailureType failureType : this.failureCounter.get((Object)FailureType.UNHANDLED)) {
            double count = this.failureCounter.get((Object)FailureType.UNHANDLED).getCount((Object)failureType);
            result.add("-- " + failureType.getName() + ": " + (int)count + " (" + count / (double)this.runCount + ")");
        }
        return result;
    }

    private MarkovFailureType getFailureType(MarkovFailureType comparator) {
        for (MarkovFailureType failureType : simFailureTypes.keySet()) {
            if (!failureType.equals(comparator)) continue;
            return failureType;
        }
        return null;
    }

    public void printHandledFailuresStatistics(Logger logger, double simulationTime) {
        if (logger.isDebugEnabled()) {
            boolean headerPrinted = false;
            HashMap<String, SoftwareFailureStatistics> softwareFailureStatisticsMap = new HashMap<String, SoftwareFailureStatistics>();
            for (MarkovFailureType failureType : this.failureCounter.get((Object)FailureType.HANDLED)) {
                int handledCount = this.failureCounter.get((Object)FailureType.HANDLED).getCount((Object)failureType);
                Integer totalFailureCount = this.failureCounter.get((Object)FailureType.TOTAL).getCount((Object)failureType);
                if (totalFailureCount == null) {
                    totalFailureCount = 0;
                }
                if (!headerPrinted) {
                    logger.debug((Object)"---- Handled Failures:");
                    headerPrinted = true;
                }
                logger.debug((Object)("- " + failureType.getName() + ": Handled " + handledCount + " out of " + totalFailureCount + " (" + (double)handledCount / (double)totalFailureCount.intValue() + ")"));
                logger.debug((Object)("  Fault rate (faults per time unit):                 " + (double)totalFailureCount.intValue() / simulationTime));
                logger.debug((Object)("  Mean time to fault (time units):                   " + simulationTime / (double)totalFailureCount.intValue()));
                logger.debug((Object)("  Non-recoverable fault rate (failures per time unit): " + (double)(totalFailureCount - handledCount) / simulationTime));
                logger.debug((Object)("  Mean time to non-recoverable failure (time units):   " + simulationTime / (double)(totalFailureCount - handledCount)));
                if (!(failureType instanceof MarkovSoftwareInducedFailureType)) continue;
                MarkovSoftwareInducedFailureType swFailureType = (MarkovSoftwareInducedFailureType)failureType;
                SoftwareFailureStatistics softwareFailureStatistics = (SoftwareFailureStatistics)softwareFailureStatisticsMap.get(swFailureType.getSoftwareFailureId());
                if (softwareFailureStatistics == null) {
                    softwareFailureStatistics = new SoftwareFailureStatistics(swFailureType.getSoftwareFailureId(), swFailureType.getSoftwareFailureName());
                    softwareFailureStatisticsMap.put(swFailureType.getSoftwareFailureId(), softwareFailureStatistics);
                }
                softwareFailureStatistics.addTotalFailureCount(totalFailureCount);
                softwareFailureStatistics.addHandledCount(handledCount);
            }
            logger.debug((Object)"\n---- Handled failures aggregated by software failure type:");
            for (SoftwareFailureStatistics softwareFailureStatistics : softwareFailureStatisticsMap.values()) {
                logger.debug((Object)("- " + softwareFailureStatistics.getName() + "(" + softwareFailureStatistics.getId() + ") : Handled " + softwareFailureStatistics.getHandledCount() + " out of " + softwareFailureStatistics.getTotalFailureCount() + " (" + (double)softwareFailureStatistics.getHandledCount() / (double)softwareFailureStatistics.getTotalFailureCount() + ")"));
                logger.debug((Object)("  Fault rate (faults per time unit):                 " + (double)softwareFailureStatistics.getTotalFailureCount() / simulationTime));
                logger.debug((Object)("  Mean time to fault (time units):                   " + simulationTime / (double)softwareFailureStatistics.getTotalFailureCount()));
                logger.debug((Object)("  Non-recoverable fault rate (failures per time unit): " + (double)(softwareFailureStatistics.getTotalFailureCount() - softwareFailureStatistics.getHandledCount()) / simulationTime));
                logger.debug((Object)("  Mean time to non-recoverable failure (time units):   " + simulationTime / (double)(softwareFailureStatistics.getTotalFailureCount() - softwareFailureStatistics.getHandledCount())));
            }
        }
    }

    public static enum FailureType {
        HANDLED,
        UNHANDLED,
        TOTAL;

    }
}

