/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.core.configuration;

import de.uka.ipd.sdq.workflow.configuration.AbstractComposedJobConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.retriever.core.service.AnalystCollection;
import org.palladiosimulator.retriever.core.service.DiscovererCollection;
import org.palladiosimulator.retriever.core.service.EmptyCollection;
import org.palladiosimulator.retriever.core.service.RuleCollection;
import org.palladiosimulator.retriever.services.Analyst;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.Service;
import org.palladiosimulator.retriever.services.ServiceCollection;
import org.palladiosimulator.retriever.services.ServiceConfiguration;

public class RetrieverConfigurationImpl
extends AbstractComposedJobConfiguration
implements RetrieverConfiguration {
    private static final Logger LOG = Logger.getLogger(RetrieverConfigurationImpl.class);
    private static final String CONFIG_PREFIX = "org.palladiosimulator.retriever.core.configuration.";
    public static final String RULE_ENGINE_INPUT_PATH = "input.path";
    public static final String RULE_ENGINE_OUTPUT_PATH = "org.palladiosimulator.retriever.core.configuration.output.path";
    public static final String RULE_ENGINE_RULES_PATH = "org.palladiosimulator.retriever.core.configuration.rules.path";
    public static final String RULE_ENGINE_SELECTED_RULES = "org.palladiosimulator.retriever.core.configuration.rules";
    public static final String RULE_ENGINE_SELECTED_ANALYSTS = "org.palladiosimulator.retriever.core.configuration.analysts";
    public static final String RULE_ENGINE_SELECTED_DISCOVERERS = "org.palladiosimulator.retriever.core.configuration.discoverers";
    public static final String RULE_ENGINE_RULE_CONFIG_PREFIX = "org.palladiosimulator.retriever.core.configuration.ruleconfig.";
    public static final String RULE_ENGINE_ANALYST_CONFIG_PREFIX = "org.palladiosimulator.retriever.core.configuration.analystconfig.";
    public static final String RULE_ENGINE_DISCOVERER_CONFIG_PREFIX = "org.palladiosimulator.retriever.core.configuration.discovererconfig.";
    private URI inputFolder;
    private URI outputFolder;
    private URI rulesFolder;
    private final Map<Class<? extends Service>, ServiceConfiguration<? extends Service>> serviceConfigs;
    private final Map<String, Object> attributes;

    public RetrieverConfigurationImpl() {
        this(new HashMap<String, Object>());
    }

    public RetrieverConfigurationImpl(Map<String, Object> attributes) {
        this.attributes = Objects.requireNonNull(attributes);
        this.serviceConfigs = new HashMap<Class<? extends Service>, ServiceConfiguration<? extends Service>>();
        Object discovererCollection = null;
        try {
            discovererCollection = new DiscovererCollection();
        }
        catch (CoreException coreException) {
            LOG.error((Object)"Exception occurred while discovering discoverers!");
            discovererCollection = new EmptyCollection();
        }
        ServiceConfiguration discovererConfig = new ServiceConfiguration((ServiceCollection)discovererCollection, RULE_ENGINE_SELECTED_DISCOVERERS, RULE_ENGINE_DISCOVERER_CONFIG_PREFIX);
        this.serviceConfigs.put(Discoverer.class, (ServiceConfiguration<? extends Service>)discovererConfig);
        Object ruleCollection = null;
        try {
            ruleCollection = new RuleCollection();
        }
        catch (CoreException coreException) {
            LOG.error((Object)"Exception occurred while discovering rules!");
            ruleCollection = new EmptyCollection();
        }
        ServiceConfiguration ruleConfig = new ServiceConfiguration((ServiceCollection)ruleCollection, RULE_ENGINE_SELECTED_RULES, RULE_ENGINE_RULE_CONFIG_PREFIX);
        ruleConfig.addDependencyProvider(discovererConfig);
        this.serviceConfigs.put(Rule.class, (ServiceConfiguration<? extends Service>)ruleConfig);
        Object analystCollection = null;
        try {
            analystCollection = new AnalystCollection();
        }
        catch (CoreException coreException) {
            LOG.error((Object)"Exception occurred while discovering analysts!");
            analystCollection = new EmptyCollection();
        }
        ServiceConfiguration analystConfig = new ServiceConfiguration((ServiceCollection)analystCollection, RULE_ENGINE_SELECTED_ANALYSTS, RULE_ENGINE_ANALYST_CONFIG_PREFIX);
        analystConfig.addDependencyProvider(discovererConfig);
        analystConfig.addDependencyProvider(ruleConfig);
        this.serviceConfigs.put(Analyst.class, (ServiceConfiguration<? extends Service>)analystConfig);
        this.applyAttributeMap(attributes);
    }

    public void applyAttributeMap(Map<String, Object> attributeMap) {
        if (attributeMap == null) {
            return;
        }
        if (attributeMap.get(RULE_ENGINE_INPUT_PATH) != null) {
            this.setInputFolder(URI.createURI((String)((String)attributeMap.get(RULE_ENGINE_INPUT_PATH))));
        }
        if (attributeMap.get(RULE_ENGINE_OUTPUT_PATH) != null) {
            this.setOutputFolder(URI.createURI((String)((String)attributeMap.get(RULE_ENGINE_OUTPUT_PATH))));
        }
        if (attributeMap.get(RULE_ENGINE_RULES_PATH) != null) {
            this.setRulesFolder(URI.createURI((String)((String)attributeMap.get(RULE_ENGINE_RULES_PATH))));
        }
        for (ServiceConfiguration<? extends Service> serviceConfig : this.serviceConfigs.values()) {
            serviceConfig.applyAttributeMap(attributeMap);
        }
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public URI getInputFolder() {
        return this.inputFolder;
    }

    public URI getOutputFolder() {
        return this.outputFolder;
    }

    public URI getRulesFolder() {
        return this.rulesFolder;
    }

    public void setInputFolder(URI inputFolder) {
        this.inputFolder = inputFolder;
    }

    public void setOutputFolder(URI outputFolder) {
        this.outputFolder = outputFolder;
    }

    public void setRulesFolder(URI rulesFolder) {
        this.rulesFolder = rulesFolder;
    }

    public <T extends Service> ServiceConfiguration<T> getConfig(Class<T> serviceClass) {
        ServiceConfiguration<? extends Service> serviceConfig = this.serviceConfigs.get(serviceClass);
        return serviceConfig;
    }

    public Map<String, Object> toMap() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put(RULE_ENGINE_INPUT_PATH, this.getInputFolder());
        result.put(RULE_ENGINE_OUTPUT_PATH, this.getOutputFolder());
        result.put(RULE_ENGINE_RULES_PATH, this.getRulesFolder());
        for (ServiceConfiguration<? extends Service> serviceConfig : this.serviceConfigs.values()) {
            result.putAll(serviceConfig.toMap());
        }
        return result;
    }
}

