/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.discoverers;

import de.uka.ipd.sdq.workflow.blackboard.Blackboard;
import de.uka.ipd.sdq.workflow.jobs.AbstractBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.CleanupFailedException;
import de.uka.ipd.sdq.workflow.jobs.IBlackboardInteractingJob;
import de.uka.ipd.sdq.workflow.jobs.JobFailedException;
import de.uka.ipd.sdq.workflow.jobs.UserCanceledException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.palladiosimulator.retriever.services.Discoverer;
import org.palladiosimulator.retriever.services.RetrieverConfiguration;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class DockerfileDiscoverer
implements Discoverer {
    private static final String DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.docker";

    public IBlackboardInteractingJob<RetrieverBlackboard> create(final RetrieverConfiguration configuration, final RetrieverBlackboard blackboard) {
        return new AbstractBlackboardInteractingJob<RetrieverBlackboard>(){

            public void cleanup(IProgressMonitor monitor) throws CleanupFailedException {
            }

            public void execute(IProgressMonitor monitor) throws JobFailedException, UserCanceledException {
                Path root = Paths.get(CommonPlugin.asLocalURI((URI)configuration.getInputFolder()).devicePath(), new String[0]);
                this.setBlackboard((Blackboard)Objects.requireNonNull(blackboard));
                HashMap dockerfiles = new HashMap();
                Discoverer.find((Path)root, (String)"Dockerfile", (Logger)this.logger).forEach(p -> {
                    Object v0 = dockerfiles.put(p, null);
                });
                ((RetrieverBlackboard)this.getBlackboard()).putDiscoveredFiles(DockerfileDiscoverer.DISCOVERER_ID, dockerfiles);
            }

            public String getName() {
                return "Dockerfile Discoverer Job";
            }
        };
    }

    public Set<String> getConfigurationKeys() {
        return Collections.emptySet();
    }

    public String getID() {
        return DISCOVERER_ID;
    }

    public String getName() {
        return "Dockerfile Discoverer";
    }
}

