package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.jdom2.Document;
import org.palladiosimulator.retriever.extraction.rules.data.GatewayRoute;
import org.palladiosimulator.retriever.extraction.rules.util.ProjectHelper;
import org.palladiosimulator.retriever.extraction.rules.util.SpringHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

@SuppressWarnings("all")
public class SpringZuulRules implements Rule {
  private static final Logger LOG = Logger.getLogger(SpringZuulRules.class);

  public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.spring.zuul";

  public static final String YAML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.yaml";

  public static final String YAML_MAPPERS_KEY = (SpringZuulRules.YAML_DISCOVERER_ID + ".mappers");

  public static final String XML_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.xml";

  public static final String PROPERTIES_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.properties";

  public static final String ECMASCRIPT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript";

  public static final String ECMASCRIPT_ROUTES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.routes";

  public static final String ECMASCRIPT_HOSTNAMES_ID = "org.palladiosimulator.retriever.extraction.rules.ecmascript.hostnames";

  @Override
  public void processRules(final RetrieverBlackboard blackboard, final Path path) {
    Object _partition = blackboard.getPartition(SpringZuulRules.YAML_DISCOVERER_ID);
    final Map<Path, Iterable<Map<String, Object>>> rawYamls = ((Map<Path, Iterable<Map<String, Object>>>) _partition);
    Object _partition_1 = blackboard.getPartition(SpringZuulRules.YAML_MAPPERS_KEY);
    final Map<Path, Function<String, Optional<String>>> yamlMappers = ((Map<Path, Function<String, Optional<String>>>) _partition_1);
    final Map<Path, Document> poms = blackboard.<Document>getDiscoveredFiles(SpringZuulRules.XML_DISCOVERER_ID, Document.class);
    final Map<Path, Properties> propertyFiles = blackboard.<Properties>getDiscoveredFiles(SpringZuulRules.PROPERTIES_DISCOVERER_ID, Properties.class);
    final Path projectRoot = ProjectHelper.findProjectRoot(path, "pom.xml");
    final Path configRoot = SpringHelper.findConfigRoot(poms);
    if ((configRoot == null)) {
      return;
    }
    Map<Path, List<GatewayRoute>> routeMap = new HashMap<Path, List<GatewayRoute>>();
    boolean _hasPartition = blackboard.hasPartition(SpringZuulRules.RULE_ID);
    if (_hasPartition) {
      Object _partition_2 = blackboard.getPartition(SpringZuulRules.RULE_ID);
      routeMap = ((Map<Path, List<GatewayRoute>>) _partition_2);
    }
    if (((projectRoot != null) && routeMap.containsKey(projectRoot))) {
      return;
    }
    Function<String, Optional<String>> _xifexpression = null;
    if ((projectRoot == null)) {
      _xifexpression = null;
    } else {
      _xifexpression = yamlMappers.get(
        SpringHelper.findFile(yamlMappers.keySet(), projectRoot.resolve("src/main/resources"), 
          Set.<String>of("bootstrap.yaml", "bootstrap.yml")));
    }
    final Function<String, Optional<String>> bootstrapYaml = _xifexpression;
    Properties _xifexpression_1 = null;
    if ((projectRoot == null)) {
      _xifexpression_1 = null;
    } else {
      _xifexpression_1 = propertyFiles.get(
        SpringHelper.findFile(propertyFiles.keySet(), projectRoot.resolve("src/main/resources"), 
          Set.<String>of("application.properties")));
    }
    final Properties applicationProperties = _xifexpression_1;
    final String applicationName = SpringHelper.getFromYamlOrProperties("spring.application.name", bootstrapYaml, applicationProperties);
    Iterable<Map<String, Object>> _xifexpression_2 = null;
    if ((configRoot == null)) {
      _xifexpression_2 = null;
    } else {
      _xifexpression_2 = rawYamls.get(
        SpringHelper.findFile(rawYamls.keySet(), configRoot.resolve("src/main/resources/shared"), 
          Set.<String>of((applicationName + ".yaml"), (applicationName + ".yml"))));
    }
    final Iterable<Map<String, Object>> projectConfigYaml = _xifexpression_2;
    final List<GatewayRoute> routes = this.collectRoutes(projectConfigYaml);
    for (final GatewayRoute route : routes) {
      String _path = route.getPath();
      String _plus = ((("Route in " + applicationName) + ": ") + _path);
      String _plus_1 = (_plus + " -> ");
      String _targetHost = route.getTargetHost();
      String _plus_2 = (_plus_1 + _targetHost);
      SpringZuulRules.LOG.warn(_plus_2);
    }
    routeMap.put(projectRoot, routes);
    boolean _hasPartition_1 = blackboard.hasPartition(SpringZuulRules.RULE_ID);
    if (_hasPartition_1) {
      Object _partition_3 = blackboard.getPartition(SpringZuulRules.RULE_ID);
      ((Map<Path, List<GatewayRoute>>) _partition_3).putAll(routeMap);
    } else {
      blackboard.addPartition(SpringZuulRules.RULE_ID, routeMap);
    }
    boolean _hasPartition_2 = blackboard.hasPartition(SpringZuulRules.ECMASCRIPT_ROUTES_ID);
    if (_hasPartition_2) {
      Object _partition_4 = blackboard.getPartition(SpringZuulRules.ECMASCRIPT_ROUTES_ID);
      final Map<Path, List<GatewayRoute>> ecmaScriptRouteMap = ((Map<Path, List<GatewayRoute>>) _partition_4);
      boolean _containsKey = ecmaScriptRouteMap.containsKey(projectRoot);
      if (_containsKey) {
        ecmaScriptRouteMap.get(projectRoot).addAll(routes);
      } else {
        ecmaScriptRouteMap.put(projectRoot, routes);
      }
    } else {
      blackboard.addPartition(SpringZuulRules.ECMASCRIPT_ROUTES_ID, routeMap);
    }
    if ((applicationName != null)) {
      Map<Path, String> hostnameMap = new HashMap<Path, String>();
      boolean _hasPartition_3 = blackboard.hasPartition(SpringZuulRules.ECMASCRIPT_HOSTNAMES_ID);
      if (_hasPartition_3) {
        Object _partition_5 = blackboard.getPartition(SpringZuulRules.ECMASCRIPT_HOSTNAMES_ID);
        hostnameMap = ((Map<Path, String>) _partition_5);
      }
      hostnameMap.put(projectRoot, applicationName);
      boolean _hasPartition_4 = blackboard.hasPartition(SpringZuulRules.ECMASCRIPT_HOSTNAMES_ID);
      boolean _not = (!_hasPartition_4);
      if (_not) {
        blackboard.addPartition(SpringZuulRules.ECMASCRIPT_HOSTNAMES_ID, hostnameMap);
      }
    }
  }

  public List<GatewayRoute> collectRoutes(final Iterable<Map<String, Object>> applicationYamlIter) {
    final ArrayList<GatewayRoute> result = new ArrayList<GatewayRoute>();
    if (((applicationYamlIter == null) || IterableExtensions.isEmpty(applicationYamlIter))) {
      return result;
    }
    Map<String, Object> _get = ((Map<String, Object>[])Conversions.unwrapArray(applicationYamlIter, Map.class))[0];
    final Map<String, Object> applicationYaml = ((Map<String, Object>) _get);
    if ((applicationYaml == null)) {
      return result;
    }
    final Object zuulObject = applicationYaml.get("zuul");
    if ((!(zuulObject instanceof Map))) {
      return result;
    }
    final Map<String, Object> zuul = ((Map<String, Object>) zuulObject);
    final Object routesObject = zuul.get("routes");
    if ((!(routesObject instanceof Map))) {
      return result;
    }
    final Map<String, Map<String, Object>> routes = ((Map<String, Map<String, Object>>) routesObject);
    Collection<Map<String, Object>> _values = routes.values();
    for (final Map<String, Object> route : _values) {
      {
        final Object pathObject = route.get("path");
        final Object serviceIdObject = route.get("serviceId");
        final Object urlObject = route.get("url");
        Object stripPrefixObject = route.get("stripPrefix");
        if (((stripPrefixObject == null) || (!(stripPrefixObject instanceof Boolean)))) {
          stripPrefixObject = Boolean.valueOf(true);
        }
        final Boolean stripPrefix = ((Boolean) stripPrefixObject);
        final boolean hasServiceId = ((serviceIdObject != null) && (serviceIdObject instanceof String));
        final boolean hasPath = ((pathObject != null) && (pathObject instanceof String));
        final boolean hasUrl = ((urlObject != null) && (urlObject instanceof String));
        if ((hasPath && (hasServiceId || hasUrl))) {
          final String path = ((String) pathObject);
          if (hasServiceId) {
            final String serviceId = ((String) serviceIdObject);
            GatewayRoute _gatewayRoute = new GatewayRoute(path, serviceId, (stripPrefix).booleanValue());
            result.add(_gatewayRoute);
          } else {
            if (hasUrl) {
              final String url = ((String) urlObject);
              String _hostname = this.toHostname(url);
              GatewayRoute _gatewayRoute_1 = new GatewayRoute(path, _hostname, (stripPrefix).booleanValue());
              result.add(_gatewayRoute_1);
            }
          }
        }
      }
    }
    return result;
  }

  public String toHostname(final String url) {
    int schemaEnd = url.lastIndexOf("://");
    if ((schemaEnd == (-1))) {
      schemaEnd = (-3);
    }
    final int hostnameStart = (schemaEnd + 3);
    int portIndex = url.indexOf(":", hostnameStart);
    if ((portIndex == (-1))) {
      portIndex = url.length();
    }
    int pathIndex = url.indexOf("/", hostnameStart);
    if ((pathIndex == (-1))) {
      pathIndex = url.length();
    }
    final int hostnameEnd = Math.min(portIndex, pathIndex);
    return url.substring(hostnameStart, hostnameEnd);
  }

  @Override
  public boolean isBuildRule() {
    return false;
  }

  @Override
  public Set<String> getConfigurationKeys() {
    return Set.<String>of();
  }

  @Override
  public String getID() {
    return SpringZuulRules.RULE_ID;
  }

  @Override
  public String getName() {
    return "Spring Zuul Rules";
  }

  @Override
  public Set<String> getRequiredServices() {
    return Set.<String>of(SpringZuulRules.YAML_DISCOVERER_ID, SpringZuulRules.XML_DISCOVERER_ID, SpringZuulRules.PROPERTIES_DISCOVERER_ID);
  }

  @Override
  public Set<String> getDependentServices() {
    return Set.<String>of(SpringZuulRules.ECMASCRIPT_RULE_ID);
  }
}
