/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Type;
import org.palladiosimulator.retriever.extraction.commonalities.CompUnitOrName;
import org.palladiosimulator.retriever.extraction.commonalities.HTTPMethod;
import org.palladiosimulator.retriever.extraction.commonalities.OperationName;
import org.palladiosimulator.retriever.extraction.commonalities.RESTOperationName;
import org.palladiosimulator.retriever.extraction.engine.PCMDetector;
import org.palladiosimulator.retriever.extraction.engine.RuleHelper;
import org.palladiosimulator.retriever.extraction.rules.util.RESTHelper;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class JaxRSRules
implements Rule {
    public static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs";
    public static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";
    public static final String DEPLOYMENT_RULE_ID = "org.palladiosimulator.retriever.extraction.rules.jax_rs.deployment";
    private static final Map<String, HTTPMethod> SERVLET_METHODS = Map.of("doGet", HTTPMethod.GET, "doPost", HTTPMethod.POST, "doDelete", HTTPMethod.DELETE, "doPut", HTTPMethod.PUT, "handleGETRequest", HTTPMethod.GET, "handlePOSTRequest", HTTPMethod.POST, "handleDELETERequest", HTTPMethod.DELETE, "handlePUTRequest", HTTPMethod.PUT);

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        CompilationUnit unit = (CompilationUnit)blackboard.getDiscoveredFiles(JAVA_DISCOVERER_ID, CompilationUnit.class).get(path);
        if (unit == null) {
            return;
        }
        Object _partition = blackboard.getPartition(DEPLOYMENT_RULE_ID);
        Map hostnameMap = (Map)_partition;
        String hostname = "SERVICE-HOST";
        Path mostSpecificHostnamePath = null;
        Set _keySet = hostnameMap.keySet();
        for (Path hostnamePath : _keySet) {
            if (hostnamePath == null || !path.startsWith(hostnamePath) || mostSpecificHostnamePath != null && !hostnamePath.startsWith(mostSpecificHostnamePath)) continue;
            hostname = (String)hostnameMap.get(hostnamePath);
            mostSpecificHostnamePath = hostnamePath;
        }
        this.processRuleForCompUnit(blackboard, unit, hostname);
    }

    public void processRuleForCompUnit(RetrieverBlackboard blackboard, CompilationUnit unit, String hostname) {
        Object _pCMDetector = blackboard.getPCMDetector();
        PCMDetector pcmDetector = (PCMDetector)_pCMDetector;
        if (pcmDetector == null) {
            return;
        }
        CompUnitOrName identifier = new CompUnitOrName(unit);
        boolean isConverter = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Converter"});
        boolean isUnitController = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"Path"});
        boolean isWebServlet = RuleHelper.isUnitAnnotatedWithName((CompilationUnit)unit, (String[])new String[]{"WebServlet"}) || RuleHelper.isImplementingOrExtending((CompilationUnit)unit, (String)"HttpServlet");
        boolean _endsWith = identifier.toString().endsWith("Test");
        if (_endsWith) {
            return;
        }
        boolean _isAbstraction = RuleHelper.isAbstraction((CompilationUnit)unit);
        if (_isAbstraction) {
            return;
        }
        if (isConverter) {
            this.detectDefault(blackboard, unit);
        } else if (isUnitController) {
            String unitPath = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"Path");
            if (unitPath == null) {
                unitPath = "";
            }
            String path = "/" + unitPath;
            pcmDetector.detectComponent(identifier);
            Consumer<MethodDeclaration> _function = m -> {
                boolean _isMethodAnnotatedWithName = RuleHelper.isMethodAnnotatedWithName((MethodDeclaration)m, (String[])new String[]{"DELETE", "GET", "HEAD", "PUT", "POST", "OPTIONS"});
                if (_isMethodAnnotatedWithName) {
                    String methodPath = RuleHelper.getMethodAnnotationStringValue((MethodDeclaration)m, (String)"Path");
                    methodPath = methodPath == null ? path : String.valueOf(path) + "/" + methodPath;
                    methodPath = RESTHelper.replaceArgumentsWithWildcards(methodPath);
                    IMethodBinding _resolveBinding = m.resolveBinding();
                    RESTOperationName _rESTOperationName = new RESTOperationName(hostname, methodPath, new HTTPMethod[0]);
                    pcmDetector.detectCompositeProvidedOperation(identifier, _resolveBinding, (OperationName)_rESTOperationName);
                }
            };
            RuleHelper.getMethods((CompilationUnit)unit).forEach(_function);
            Consumer<FieldDeclaration> _function_1 = f -> pcmDetector.detectRequiredInterfaceWeakly(identifier, f);
            RuleHelper.getFields((CompilationUnit)unit).forEach(_function_1);
            pcmDetector.detectPartOfComposite(identifier, RuleHelper.getUnitName((CompilationUnit)unit));
        } else if (isWebServlet) {
            String unitPath_1 = RuleHelper.getUnitAnnotationStringValue((CompilationUnit)unit, (String)"WebServlet");
            if (unitPath_1 == null) {
                unitPath_1 = "";
            }
            String path_1 = "/" + unitPath_1;
            pcmDetector.detectComponent(identifier);
            Consumer<MethodDeclaration> _function_2 = m -> {
                boolean _containsKey = SERVLET_METHODS.containsKey(m.getName().getIdentifier());
                if (_containsKey) {
                    IMethodBinding _resolveBinding = m.resolveBinding();
                    Set<HTTPMethod> _of = Set.of(SERVLET_METHODS.get(m.getName().getIdentifier()));
                    RESTOperationName _rESTOperationName = new RESTOperationName(hostname, path_1, _of);
                    pcmDetector.detectProvidedOperation(identifier, _resolveBinding, (OperationName)_rESTOperationName);
                }
            };
            RuleHelper.getMethods((CompilationUnit)unit).forEach(_function_2);
            Consumer<FieldDeclaration> _function_3 = f -> pcmDetector.detectRequiredInterfaceWeakly(identifier, f);
            RuleHelper.getFields((CompilationUnit)unit).forEach(_function_3);
            pcmDetector.detectPartOfComposite(identifier, RuleHelper.getUnitName((CompilationUnit)unit));
        } else {
            this.detectDefault(blackboard, unit);
        }
        List _allAbstractParents = RuleHelper.getAllAbstractParents((CompilationUnit)unit);
        for (Type parent : _allAbstractParents) {
            ITypeBinding parentBinding = parent.resolveBinding();
            pcmDetector.detectProvidedInterfaceWeakly(identifier, parentBinding);
            List _methods = RuleHelper.getMethods((Type)parent);
            for (IMethodBinding m2 : _methods) {
                pcmDetector.detectProvidedOperationWeakly(identifier, parentBinding, m2);
            }
        }
    }

    public void detectDefault(RetrieverBlackboard blackboard, CompilationUnit unit) {
        boolean _not;
        Object _pCMDetector = blackboard.getPCMDetector();
        PCMDetector pcmDetector = (PCMDetector)_pCMDetector;
        CompUnitOrName identifier = new CompUnitOrName(unit);
        pcmDetector.detectComponent(identifier);
        Consumer<MethodDeclaration> _function = m -> pcmDetector.detectProvidedOperationWeakly(identifier, m.resolveBinding());
        RuleHelper.getAllPublicMethods((CompilationUnit)unit).forEach(_function);
        boolean _endsWith = identifier.name().endsWith("ServiceImpl");
        boolean bl = _not = !_endsWith;
        if (_not) {
            Consumer<FieldDeclaration> _function_1 = f -> pcmDetector.detectRequiredInterfaceWeakly(identifier, f);
            RuleHelper.getFields((CompilationUnit)unit).forEach(_function_1);
        }
    }

    public boolean isBuildRule() {
        return false;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "JAX RS Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(JAVA_DISCOVERER_ID, DEPLOYMENT_RULE_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of();
    }
}

