/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.palladiosimulator.retriever.services.Rule;
import org.palladiosimulator.retriever.services.blackboard.RetrieverBlackboard;

public class MavenRules
implements Rule {
    private static final String RULE_ID = "org.palladiosimulator.retriever.extraction.rules.maven";
    private static final String JAVA_DISCOVERER_ID = "org.palladiosimulator.retriever.extraction.discoverers.java";
    private static final String MAVEN_FILE_NAME = "pom.xml";

    public void processRules(RetrieverBlackboard blackboard, Path path) {
        if (path != null && path.getFileName().toString().equals(MAVEN_FILE_NAME)) {
            HashSet<CompilationUnit> children = new HashSet<CompilationUnit>();
            Path parentPath = path.getParent();
            Set _entrySet = blackboard.getDiscoveredFiles(JAVA_DISCOVERER_ID, CompilationUnit.class).entrySet();
            for (Map.Entry entry : _entrySet) {
                boolean _startsWith = ((Path)entry.getKey()).startsWith(parentPath);
                if (!_startsWith) continue;
                children.add((CompilationUnit)entry.getValue());
            }
            blackboard.addSystemAssociations(path, children);
        }
    }

    public boolean isBuildRule() {
        return true;
    }

    public Set<String> getConfigurationKeys() {
        return Set.of();
    }

    public String getID() {
        return RULE_ID;
    }

    public String getName() {
        return "Maven Rules";
    }

    public Set<String> getRequiredServices() {
        return Set.of(JAVA_DISCOVERER_ID);
    }

    public Set<String> getDependentServices() {
        return Set.of();
    }
}

