/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.retriever.extraction.rules.util;

import com.google.common.base.Objects;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pair;
import org.jdom2.Document;
import org.jdom2.Element;

public final class SpringHelper {
    private static final Logger LOG = Logger.getLogger(SpringHelper.class);

    public SpringHelper() {
        try {
            throw new IllegalAccessException();
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public static Path findConfigRoot(Map<Path, Document> poms) {
        boolean _greaterThan;
        if (poms == null) {
            return null;
        }
        Function<Map.Entry, Pair> _function = entry -> {
            Path _key = (Path)entry.getKey();
            Element _child = ((Document)entry.getValue()).getRootElement().getChild("dependencies", ((Document)entry.getValue()).getRootElement().getNamespace());
            return Pair.of((Object)_key, (Object)_child);
        };
        Predicate<Pair> _function_1 = entry -> {
            Element _value = (Element)entry.getValue();
            return _value != null;
        };
        Function<Pair, Pair> _function_2 = entry -> {
            Path _key = (Path)entry.getKey();
            List _children = ((Element)entry.getValue()).getChildren("dependency", ((Element)entry.getValue()).getNamespace());
            return Pair.of((Object)_key, (Object)_children);
        };
        Predicate<Pair> _function_3 = entry -> {
            boolean _isEmpty = ((List)entry.getValue()).isEmpty();
            return !_isEmpty;
        };
        Predicate<Pair> _function_4 = entry -> {
            Functions.Function1 _function_5 = dependency -> {
                String _childTextTrim = dependency.getChildTextTrim("groupId", dependency.getNamespace());
                return Objects.equal((Object)_childTextTrim, (Object)"org.springframework.cloud");
            };
            Functions.Function1 _function_6 = dependency -> {
                String _childTextTrim = dependency.getChildTextTrim("artifactId", dependency.getNamespace());
                return Objects.equal((Object)_childTextTrim, (Object)"spring-cloud-config-server");
            };
            return IterableExtensions.exists((Iterable)IterableExtensions.filter((Iterable)((Iterable)entry.getValue()), (Functions.Function1)_function_5), (Functions.Function1)_function_6);
        };
        List configRoots = poms.entrySet().stream().map(_function).filter(_function_1).map(_function_2).filter(_function_3).filter(_function_4).collect(Collectors.toList());
        int _size = configRoots.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            Path _parent = ((Path)((Pair)configRoots.get(0)).getKey()).getParent();
            String _plus = "Multiple Spring config servers, choosing \"" + _parent;
            String _plus_1 = String.valueOf(_plus) + "\" arbitrarily";
            LOG.warn((Object)_plus_1);
        } else {
            boolean _isEmpty = configRoots.isEmpty();
            if (_isEmpty) {
                return null;
            }
        }
        return ((Path)((Pair)configRoots.get(0)).getKey()).getParent();
    }

    public static Path findFile(Set<Path> paths, Path directory, Set<String> possibleNames) {
        boolean _greaterThan;
        if (paths == null || directory == null || possibleNames == null) {
            return null;
        }
        Predicate<Path> _function = path2 -> {
            Path _parent = path2.getParent();
            return Objects.equal((Object)_parent, (Object)directory);
        };
        Predicate<Path> _function_1 = path -> possibleNames.contains(path.getFileName().toString());
        List candidates = paths.stream().filter(_function).filter(_function_1).collect(Collectors.toList());
        int _size = candidates.size();
        boolean bl = _greaterThan = _size > 1;
        if (_greaterThan) {
            String fileName = possibleNames.iterator().next();
            Path _relativize = directory.relativize((Path)candidates.get(0));
            String _plus = "Multiple " + fileName + " in " + directory + ", choosing " + _relativize;
            String _plus_1 = String.valueOf(_plus) + " arbitrarily";
            LOG.warn((Object)_plus_1);
        } else {
            boolean _isEmpty = candidates.isEmpty();
            if (_isEmpty) {
                return null;
            }
        }
        return (Path)candidates.get(0);
    }

    public static String getFromYamlOrProperties(String key, Function<String, Optional<String>> yamlMapper, Properties properties) {
        Optional<String> result;
        boolean _isPresent;
        if (yamlMapper != null && (_isPresent = (result = yamlMapper.apply(key)).isPresent())) {
            return result.get();
        }
        if (properties != null) {
            return properties.getProperty(key);
        }
        return null;
    }
}

